
#include <PalmOS.h>
#include <PalmCompatibility.h>
#include <SerialMgrOld.h>

#include "graph.h"
#include "nmeadb.h"
#include "waypoints.h"

#include "gui-rc.h"
#include "gui.h"


/* application id */
#define TZGPSAppID    'TZGP'


/* error codes */
#define ERR_CREATE_DB  50
#define ERR_OPEN_DB  60

extern UInt32 last_fix_utc;  /* time, in seconds UTC, of the last valid fix */
extern char last_fix_nmea[81];  /* NMEA string of last fix (GLL or GGA only) */

extern UInt16 maxR;
extern UInt8 highres;

/* Last fix, expressed in a different way. */
extern int lgtdeg, lgtmin, lgtfrac; /* longitude degrees, minutes, fraction */
extern int latdeg, latmin, latfrac; /* latitude degrees, minutes, fraction */
extern Int16 lat, lgt; /* degree-minutes */
extern char latns, lgtew;

extern int day, month, year;        /* UTC date */
extern int hour, min, sec, secfrac; /* UTC time */

extern int altitude, altfrac, heading, speed, headingfrac, speedfrac;
extern char altunit;

/* quality flags */
extern char qual_gll;
extern char qual_gga;
extern char qual_gsa;

/* mesage recieved flag bits */
extern int rcvd_gll;   /* received long/lat/time triplet */
extern int rcvd_gga;   /* received an altitude recently */
extern int rcvd_rmc;   /* received date/speed/heading recently */
extern int rcvd_sats;  /* received satelite positions recently */

/* satelite stuff */
struct satstat_s {
	int num, elev, azim, sn, fix;
} typedef satstat;

/* infos about our screen */
struct tzscreen_s {
	Boolean	highres;		/* are we in Handera highres mode */
	UInt8   scale;		/* scale factor multiplied by 10 */
	UInt16  radius;		/* radius of the sat circle */
	UInt16  cx;			/* center of the sat circle */
	UInt16  cy;
	UInt16  width, height;
} typedef tzscreen;

extern tzscreen myScreen;

extern satstat sats[12];

extern int totsats, fixsats;

extern char battery[5];  /* battery life string (Magellan GPS) */

Int32 get_data_age (void);
UInt32 get_now_utc (void);

/* ========================== END OF FILE ============================ */
