
/* linux (posix?) says val should be an int */
//#include <string.h>
#define VALT int
#define SIZET size_t

/* really a short is enough, but we get compiler warnings otherwise */
typedef long size_t;

extern inline SIZET strlen(const char *src)
{
  register SIZET num = 0;
  while ((*src++))
    num++;
  return num;
}

extern inline void *memcpy(void *dst, const void *src, SIZET num)
{
  register void *ds = dst;
  while (num--)
    *((char *) dst)++ = *((char *) src)++;
  return ds;
}

extern inline int memcmp(const void *dst, const void *src, SIZET num)
{

  while (num-- && (*((char *) dst)++ == *((char *) src)++));
  if (num >= 0)
    return *--((char *) dst) - *--((char *) src);
  else
    return 0;
}

extern inline void *memset(void *dst, VALT val, SIZET num)
{
  register void *ds = dst;
  while (num--)
    *((char *) dst)++ = val;
  return ds;
}

extern inline void *memccpy(void *dst, const void *src, int c, SIZET num)
{
  register void *ds = dst;
  while (num-- && *((char *) src) != c)
    *((char *) dst)++ = *((char *) src)++;
  if (num >= 0)
    *((char *) dst)++ = *((char *) src)++;
  return ds;
}

extern inline void *memmove(void *dst, const void *src, SIZET num)
{
  register void *ds = dst;
  if (dst < src || dst >= src + num)
    while (num--)
      *((char *) dst)++ = *((char *) src)++;
  else {
    dst += num;
    src += num;
    while (num--)
      *--((char *) dst) = *--((char *) src);
  }
  return ds;
}

extern inline char *strcat(char *dst, const char *src)
{
  register char *ds = dst;
  while (*dst)
    dst++;
  while ((*dst++ = *src++));
  return ds;
}

extern inline char *strncat(char *dst, const char *src, SIZET num)
{
  register char *ds = dst;
  while (*dst)
    dst++;
  while (num-- && (*dst++ = *src++));
  return ds;
}

extern inline char *strcpy(char *dst, const char *src)
{
  register char *ds = dst;
  while ((*dst++ = *src++));
  return ds;
}

extern inline int strcmp(const char *dst, const char *src)
{
  while (*dst && *src && (*dst++ == *src++));
  if (*dst && *src)
    return *--src - *--dst;
  else
    return *src - *dst;
}

extern inline int strncmp(const char *dst, const char *src, SIZET num)
{
  while (num && *dst && *src && (*dst++ == *src++))
    num--;
  if( !num )
    return 0;
  if (*dst && *src)
    return *--src - *--dst;
  else
    return *src - *dst;
}

extern inline char *strncpy(char *dst, const char *src, SIZET num)
{
  register char *ds = dst;
  while (num-- && (*dst++ = *src++));
  if (num >= 0)
    while (num--)
      *dst++ = 0;
  return ds;
}

extern inline void *memchr(const void *dst, VALT val, SIZET num)
{
  char *dstl = (void *)dst;
  while (num-- && *dstl++ != val);
  if (num >= 0)
    return (void *) --dstl;
  else
    return NULL;
}

extern inline char *strchr(const char *dst, int val)
{
  char *dstl = (char *)dst;
  while (*dstl && *dstl != val)
    dstl++;
  if (*dstl != val)
    return NULL;
  else
    return dstl;
}
