
/*
 * FILE:
 * waypoints.c
 *
 * FUNCTION:
 * Waypoint logger for tzgps
 *
 * HISTORY:
 * Linas Vepstas January 2002
 */

#include "tzgps.h"

// ========================================================== 

#define GpsDBType   'Data'

static DmOpenRef
OpenDatabase(char * dbname)
{
   DmOpenRef *dbref;
   LocalID lid;

   lid = DmFindDatabase (0, dbname);
	if (0 == lid) 
	{
		if (DmCreateDatabase(0, dbname, TZGPSAppID, GpsDBType, false)) 
		{
			return NULL;
		}
      lid = DmFindDatabase (0, dbname);
	}
   dbref = DmOpenDatabase (0, lid, dmModeReadWrite);
	return dbref;
}

// ========================================================== 

DmOpenRef  NmeaDB = NULL;
char       NmeaDBName[] = "TZGPS NMEA DB";

DmOpenRef  WaypointDB = NULL;
char       WaypointDBName[] = "TZGPS Waypoint DB";

void 
OpenNmeaDatabase(void)
{
   NmeaDB = OpenDatabase (NmeaDBName);
}

void
CloseNmeaDatabase(void)
{
	if (NmeaDB) 
   {
      DmCloseDatabase (NmeaDB);
   }
   NmeaDB = NULL;
}

void 
OpenWaypointDatabase(void)
{
   WaypointDB = OpenDatabase (WaypointDBName);
}

void
CloseWaypointDatabase(void)
{
	if (WaypointDB) 
   {
      DmCloseDatabase (WaypointDB);
   }
   WaypointDB = NULL;
}

// ========================================================== 
/* copy string to the database */

static Int16
StoreMsg (DmOpenRef *dbref, char *buff)
{
   UInt16       index = 0;
   VoidHand     RecHandle;
   MemPtr       RecPointer;
   int sz;

   if (NULL == dbref) return -1;
   sz = StrLen(buff) +1;

   RecHandle = DmNewRecord(dbref, &index, sz);
   RecPointer = MemHandleLock(RecHandle);

   DmWrite(RecPointer, 0, buff, sz);

   MemPtrUnlock(RecPointer);
   DmReleaseRecord(dbref, index, true);

   return index;
}

Int16
StoreNmeaMsg (char *buff)
{
   return StoreMsg (NmeaDB, buff);
}

Int16
StoreWaypointMsg (char *buff)
{
   return StoreMsg (WaypointDB, buff);
}

// ========================= END OF FILE ===================
