#pragma pack(2)
#include <Common.h>
#include <System/SysAll.h>
#include <UI/UIAll.h>
#include <SerialMgr.h>
#include <System/SysEvtMgr.h>

#define size_t int
#include "stringil.h"

UInt16 SerL;
static char param[20][20];

#define BUFMAX 512
static char bigbuf[BUFMAX];
int bufful;

int lgtdeg, lgtmin, lgtfrac;
int latdeg, latmin, latfrac;
int hour, min, sec, secfrac;
int day, month, year;
int altitude, altfrac, heading, speed, headingfrac, speedfrac;

char latns, lgtew, altunit, qual, fix, qual2;

DateTimeType dt;

struct {
  Int32 timedif;
  Int16 lat;
  Int16 lgt;
  char latns;
  char lgtew;
} prf;

struct satstat {
  int num, elev, azim, sn, fix;
} sats[12];

int totsats, fixsats;

/* ************************* */
/* Sine and Cosine for compass type things */

long int sinetab[91] =
  { 0, 571, 1143, 1714, 2285, 2855, 3425, 3993, 4560, 5126, 5690, 6252, 6812,
  7371, 7927, 8480, 9032, 9580, 10125, 10668, 11207, 11743, 12275, 12803,
  13327, 13848, 14364, 14876, 15383, 15886, 16383, 16876, 17364, 17846, 18323,
  18794, 19260, 19720, 20173, 20621, 21062, 21497, 21926, 22347, 22762, 23170,
  23571, 23964, 24351, 24730, 25101, 25465, 25821, 26169, 26509, 26841, 27165,
  27481, 27788, 28087, 28377, 28659, 28932, 29196, 29451, 29697, 29935, 30163,
  30381, 30591, 30791, 30982, 31164, 31336, 31498, 31651, 31794, 31928, 32051,
  32165, 32270, 32364, 32449, 32523, 32588, 32643, 32688, 32723, 32748, 32763,
  32768
};

#define icos(x) isin((x)+90)

long int isin(int angle)
{
  while (angle >= 360)
    angle -= 360;
  while (angle < 0)
    angle += 360;

  if (angle <= 90)
    return sinetab[angle];
  if (angle <= 180)
    return sinetab[180 - angle];
  if (angle <= 270)
    return -sinetab[angle - 180];
  return -sinetab[360 - angle];
}

RectangleType r;

/* ************************* */

void printtd() {
      char ebuf[40], ibuf[20];
      unsigned long int td, td1;

      //      td = timedif / 3600;

      StrIToA(ebuf, prf.timedif);
#if 0
      strcat(ebuf, ":");

      td *= 3600;
      td1 = prf.timedif - td;

      td = td1 / 60;
      td1 %= 60;

      StrIToA(ibuf, 100 + td);
      strcat(ebuf, &ibuf[1]);
      strcat(ebuf, ":");
      StrIToA(ibuf, 100 + td1);
      strcat(ebuf, &ibuf[1]);
#endif
      strcat(ebuf, "   ");
      WinDrawChars(ebuf, strlen(ebuf), 50, 150);
    }

void teardown()
{
  SerClose(SerL);
  PrefSetAppPreferences('TZGP', 0, 1, &prf, sizeof(prf), true);
}

#define DrawPixel(x,y) WinDrawLine(x,y,x,y);

void DrawCircle(short int cx, short int cy, short int r) {
  short int d,x,y;
  d = -r; x = r; y = 0;
  while(x>=y) {
    DrawPixel(cx+x,cy+y);
    DrawPixel(cx+x,cy-y);
    DrawPixel(cx+y,cy+x);
    DrawPixel(cx+y,cy-x);
    DrawPixel(cx-x,cy+y);
    DrawPixel(cx-x,cy-y);
    DrawPixel(cx-y,cy+x);
    DrawPixel(cx-y,cy-x);
    d += y+y+1;
    if( d > 0 ) {
      --x;
      d -= (x+x);
    }
    y++;
  }
}

void setup()
{
  SerSettingsType serSettings;
  int i, j;
  UInt16 pfsz = sizeof(prf);
  char initstr[128], ebuf[12];
  unsigned char sum, *cp;

  PrefGetAppPreferences('TZGP', 0, &prf.timedif, &pfsz, true);

  printtd();

  TimSecondsToDateTime(TimGetSeconds() - prf.timedif, &dt);
  strcpy(initstr, "$PRWIINIT,V,,," );


  StrIToA(ebuf, prf.lat);
  strcat(initstr, ebuf);
  strcat(initstr, ",");
  strncat(initstr, &prf.latns,1);
  strcat(initstr, ",");
  StrIToA(ebuf, prf.lgt);
  strcat(initstr, ebuf);
  strcat(initstr, ",");
  strncat(initstr, &prf.lgtew,1);
  strcat(initstr,",,,,,,");

  StrIToA(ebuf, dt.hour + 100);
  strcat(initstr, &ebuf[1]);
  StrIToA(ebuf, dt.minute + 100);
  strcat(initstr, &ebuf[1]);
  StrIToA(ebuf, dt.second + 100);
  strcat(initstr, &ebuf[1]);
  strcat(initstr, ",");
  StrIToA(ebuf, dt.day + 100);
  strcat(initstr, &ebuf[1]);
  StrIToA(ebuf, dt.month + 100);
  strcat(initstr, &ebuf[1]);
  StrIToA(ebuf, dt.year - 1900);
  strcat(initstr, &ebuf[1]);
  sum = 0;
  cp = initstr;
  while (*++cp)
    sum ^= *cp;
  StrIToH(ebuf, sum);
  strcat(initstr, "*");
  strcat(initstr, &ebuf[6]);
  strcat(initstr, "\r\n");

#define BAUD 4800

  bufful = 0;

  SysLibFind("Serial Library", &SerL);
  SerOpen(SerL, 0, BAUD);
  SerGetSettings(SerL, &serSettings);
  serSettings.flags = serSettingsFlagBitsPerChar8 | serSettingsFlagStopBits1;
  SerSetSettings(SerL, &serSettings);

  SerSend10(SerL, initstr, strlen(initstr));

  latdeg = latmin = latfrac = lgtdeg = lgtmin = lgtfrac = 0;
  day = month = year = hour = min = sec = secfrac = 0;
  altitude = heading = speed = headingfrac = speedfrac = 0;

  latns = lgtew = altunit = qual = qual2 = fix = ' ';
  totsats = fixsats = 0;

  for (i = 0; i < 12; i++)
    sats[i].num = sats[i].elev = sats[i].azim = sats[i].sn = sats[i].fix = 0;

  /****** SATELLITE COMPASS VIEW ******/

#define MAXR 60
#if 0
  r.topLeft.x = MAXR, r.topLeft.y = 0, r.extent.x = 1, r.extent.y = 2 * MAXR;
  WinDrawRectangle(&r, 0);
  r.topLeft.x = 0, r.topLeft.y = MAXR, r.extent.x = 2 * MAXR, r.extent.y = 1;
  WinDrawRectangle(&r, 0);


  for (i = 0; i < 360; i += 3) {
    int xv, yv;
    xv = icos(90 - i) * MAXR / 32768;
    yv = isin(90 - i) * MAXR / 32768;

    DrawPixel(MAXR + xv, MAXR - yv );
    if ((i % 30)) {
      DrawPixel( MAXR + xv * 2 / 3 ,  MAXR - yv * 2 / 3 );
      if (i & 1)
        continue;
      DrawPixel(MAXR + xv / 3, MAXR - yv / 3 );
    } 
  }
#endif
  DrawCircle(MAXR,MAXR,MAXR);
  DrawCircle(MAXR,MAXR,MAXR/3);
  DrawCircle(MAXR,MAXR,MAXR*2/3);

  for (i = 0; i < 360; i += 30) {
    WinDrawLine( MAXR,MAXR,MAXR+(icos(90 - i) * MAXR / 32768),MAXR+(isin(90 - i) * MAXR / 32768));
  }

}

void printsats()
{
  int i, j, a;
  int xv, yv;

  for (i = 0; i < totsats; i++) {
    if (sats[i].elev == 0)
      continue;

    a = 90 - sats[i].azim;

    xv = icos(a) * MAXR / 32768;
    yv = isin(a) * MAXR / 32768;

    r.topLeft.x = MAXR + (90 - sats[i].elev) * xv / 90;
    r.topLeft.y = MAXR - (90 - sats[i].elev) * yv / 90;

    r.extent.x = 1, r.extent.y = 1;

    if (sats[i].sn) {
      j = (sats[i].sn - 34) / 3 + 1;
      r.topLeft.x -= j / 2;
      r.topLeft.y -= j / 2;
      r.extent.x += j;
      r.extent.y += j;
    }

    WinDrawRectangle(&r, 0);

    if (sats[i].fix) {
      r.topLeft.x++;
      r.topLeft.y++;
      r.extent.x -= 2;
      r.extent.y -= 2;
      WinEraseRectangle(&r, 0);
    }

  }
}

void printlat()
{
  char ebuf[40], ibuf[20];

  StrIToA(ebuf, latdeg);
  strcat(ebuf, "\260");
  StrIToA(ibuf, latmin);
  strcat(ebuf, ibuf);
  strcat(ebuf, ".");
  StrIToA(ibuf, latfrac + 10000);
  strcat(ebuf, &ibuf[1]);
  strcat(ebuf, "'");
  ibuf[0] = latns;
  ibuf[1] = 0;
  strcat(ebuf, ibuf);
  strcat(ebuf, " ");
  WinDrawChars(ebuf, strlen(ebuf), 50, 120);
}

void printlong()
{
  char ebuf[40], ibuf[20];
  StrIToA(ebuf, lgtdeg);
  strcat(ebuf, "\260");
  StrIToA(ibuf, lgtmin);
  strcat(ebuf, ibuf);
  strcat(ebuf, ".");
  StrIToA(ibuf, lgtfrac + 10000);
  strcat(ebuf, &ibuf[1]);
  strcat(ebuf, "'");
  ibuf[0] = lgtew;
  ibuf[1] = 0;
  strcat(ebuf, ibuf);
  strcat(ebuf, " ");
  WinDrawChars(ebuf, strlen(ebuf), 50, 130);
}

void printhms()
{
  char ebuf[40], ibuf[20];

  StrIToA(ebuf, hour);
  strcat(ebuf, ":");
  StrIToA(ibuf, min + 100);
  strcat(ebuf, &ibuf[1]);
  strcat(ebuf, ":");
  StrIToA(ibuf, sec + 100);
  strcat(ebuf, &ibuf[1]);
  strcat(ebuf, ".");
  StrIToA(ibuf, secfrac + 100);
  strcat(ebuf, &ibuf[1]);
  strcat(ebuf, " ");
  WinDrawChars(ebuf, strlen(ebuf), 50, 140);
}


void printmdy()
{
  char ebuf[40], ibuf[20];
  StrIToA(ebuf, month);
  strcat(ebuf, "/");
  StrIToA(ibuf, day);
  strcat(ebuf, ibuf);
  strcat(ebuf, "/");
  StrIToA(ibuf, year);
  strcat(ebuf, ibuf);
  strcat(ebuf, "   ");
  WinDrawChars(ebuf, strlen(ebuf), 110, 140);
}

void printspeed()
{
  char ebuf[40], ibuf[20];
  StrIToA(ebuf, speed);
  strcat(ebuf, ".");
  StrIToA(ibuf, speedfrac);
  strcat(ebuf, ibuf);
  strcat(ebuf, " Knts   ");
  WinDrawChars(ebuf, strlen(ebuf), 0, 120);
}

void printhdg()
{
  char ebuf[40], ibuf[20];
  StrIToA(ebuf, heading);
  strcat(ebuf, ".");
  StrIToA(ibuf, headingfrac);
  strcat(ebuf, ibuf);
  strcat(ebuf, "\260       ");
  WinDrawChars(ebuf, strlen(ebuf), 0, 130);
#if 0
  {
    int a,xv,yv;
  a = 90 - heading;
  xv = icos(a) * MAXR / 32768;
  yv = isin(a) * MAXR / 32768;
  WinDrawLine(MAXR+xv-3,MAXR+yv-3,MAXR+xv+3,MAXR+yv+3);
  WinDrawLine(MAXR+xv-3,MAXR+yv+3,MAXR+xv+3,MAXR+yv-3);

  }
#endif
}

void printalt()
{
  char ebuf[40], ibuf[20];

  StrIToA(ebuf, altitude);
  //  strcat(ebuf, ".");
  //  StrIToA(ibuf, altfrac);
  //  strcat(ebuf, ibuf);
  ibuf[0] = altunit;
  ibuf[1] = 0;
  strcat(ebuf, ibuf);
  strcat(ebuf, "    ");
  WinDrawChars(ebuf, strlen(ebuf), 0, 140);
}


void dolat(char *parm)
{
  char editbuf[20];

  strncpy(editbuf, parm, 2);
  editbuf[2] = 0;
  latdeg = StrAToI(editbuf);

  strncpy(editbuf, &parm[2], 2);
  editbuf[2] = 0;
  latmin = StrAToI(editbuf);

  strncpy(editbuf, &parm[5], 4);
  strcat(editbuf, "0000");
  editbuf[4] = 0;
  latfrac = StrAToI(editbuf);
}

void dolong(char *parm)
{
  char editbuf[20];

  strncpy(editbuf, parm, 3);
  editbuf[3] = 0;
  lgtdeg = StrAToI(editbuf);

  strncpy(editbuf, &parm[3], 2);
  editbuf[2] = 0;
  lgtmin = StrAToI(editbuf);

  strncpy(editbuf, &parm[6], 4);
  strcat(editbuf, "0000");
  editbuf[4] = 0;
  lgtfrac = StrAToI(editbuf);
}

void dohms(char *parm)
{
  char editbuf[20];

  strncpy(editbuf, parm, 2);
  editbuf[2] = 0;
  hour = StrAToI(editbuf);

  strncpy(editbuf, &parm[2], 2);
  editbuf[2] = 0;
  min = StrAToI(editbuf);

  strncpy(editbuf, &parm[4], 2);
  editbuf[2] = 0;
  sec = StrAToI(editbuf);

  strncpy(editbuf, &parm[7], 2);
  editbuf[2] = 0;
  secfrac = StrAToI(editbuf);
}

void getparms(char *buf, int max)
{
  char *bp, *pp;
  int i;

  pp = &buf[6];
  bp = &buf[7];
  i = 0;
  while (*bp) {
    if (*bp++ == ',') {
      bp[-1] = 0;
      strcpy(param[i++], pp);
      pp = bp;
      if (i > max)
        break;
    }
  }
  strcpy(param[i++], pp);
  while (i < max)
    param[i++][0] = 0;

}

void dollt(int a, int b, int c, int d, int e)
{
  dolat(param[a]);
  latns = param[b][0];
  dolong(param[c]);
  lgtew = param[d][0];
  dohms(param[e]);
}

short checksum(char *buf)
{
  unsigned char sum = 0;
  char *p = buf, hx[10];

  while (*++p != '*')
    sum ^= *p;
  StrIToH(hx, sum);
  return (strncmp(hx, ++p, 2) == 0);
}

/* ************************* */

int decgps(char *buf)
{
  int i, j, k;
  char editbuf[20];

  if (!strncmp("GPGSV", buf, 5)) {
    getparms(buf, 20);

    totsats = StrAToI(param[2]);
    j = (StrAToI(param[1]) - 1) * 4;


    for (i = 3; i < 16; j++) {
      sats[j].num = StrAToI(param[i++]);
      sats[j].elev = StrAToI(param[i++]);
      sats[j].azim = StrAToI(param[i++]);
      sats[j].sn = StrAToI(param[i++]);
    }

    if (j > 10)
      printsats();

  } else if (!strncmp("GPGLL", buf, 5)) {

    getparms(buf, 6);

    dollt(0, 1, 2, 3, 4);
    qual = param[5][0];         // 'A'

    printlat();
    printlong();
    printhms();

  } else if (!strncmp("GPRMC", buf, 5)) {

    getparms(buf, 9);

    qual = param[1][0];         // 'A'

    dollt(2, 3, 4, 5, 0);

    strncpy(editbuf, param[8], 2);
    editbuf[2] = 0;
    day = StrAToI(editbuf);

    strncpy(editbuf, &param[8][2], 2);
    editbuf[2] = 0;
    month = StrAToI(editbuf);

    strncpy(editbuf, &param[8][4], 2);
    editbuf[2] = 0;
    year = StrAToI(editbuf);

    if( qual == 'A' && qual2 == '1' ) {

      dt.second = sec;
      dt.minute = min;
      dt.hour = hour;
      dt.day = day;
      dt.month = month;
      dt.year = year+2000;
      dt.weekDay = DayOfWeek(month, day, year);
      prf.timedif = TimGetSeconds() - TimDateTimeToSeconds(&dt);
#if 0
      {
	ULong td = prf.timedif % 3600;
	if( ( td < 600 && td > 2 ) || ( td > 600 && td < -2 ) ) {
	  TimSetSeconds(TimGetSeconds() - td);
	  prf.timedif = TimGetSeconds() - TimDateTimeToSeconds(&dt);
	}
      }
#endif
      prf.lat=StrAToI(param[2]);
      prf.latns=param[3][0];
      prf.lgt=StrAToI(param[4]);
      prf.lgtew=param[5][0];

      printtd();
    }

    printlat();
    printlong();
    printhms();

    speed = StrAToI(param[6]);
    {
      char *cp = param[6];
      while(*cp++ != '.' )
	if( !*cp )
	  break;
      speedfrac = StrAToI(cp);
    }
#if 0
    strcpy(editbuf,param[6]);
    strcat(editbuf,"   ");
    WinDrawChars(editbuf,strlen(editbuf),0,150);
#endif
    heading = StrAToI(param[7]);
    headingfrac = StrAToI(&param[7][4]);

    printmdy();
    printspeed();
    printhdg();

  } else
   if (!strncmp("GPGGA", buf, 5)) {

    getparms(buf, 10);

    dollt(1, 2, 3, 4, 0);
    qual2 = param[1][5];         // '1'

    printlat();
    printlong();
    printhms();

    /* ************************* */

    fixsats = StrAToI(param[6]);
    altitude = StrAToI(param[8]);
    //    altfrac = StrAToI(&param[8][4]);
    altunit = param[9][0];

    printalt();

  } else if (!strncmp("GPGSA", buf, 5)) {

    getparms(buf, 18);

    // Auto/Man fix sel

    // fix type ?/2/3 D

    for (i = 0; i < 12; i++)
      sats[i].fix = 0;

    for (j = 0; j < 12; j++)
      if ((k = StrAToI(param[j + 2])))
        for (i = 0; i < totsats; i++)
          if (sats[i].num == k) {
            sats[i].fix = 1;
            break;
          }


  } else {

    WinDrawChars(buf, 5, 120, 0);
    return 1;
  }
  return 0;
}


void doser()
{
  int i;
  long full;
  char *bp;

  if (SerReceiveCheck(SerL, &full))
    SerClearErr(SerL);

  if (!full)
    return;

  if (full + bufful > BUFMAX)
    full = BUFMAX - bufful;

  if (full)
    SerReceive10(SerL, &bigbuf[bufful], full, -1);

  bufful += full;

  for (;;) {

    if (bigbuf[0] != '$') {
      bp = bigbuf;
      while (*bp != '$' && bufful)
        bp++, bufful--;

      if (!bufful)
        return;

      memcpy(bigbuf, bp, bufful);
    }

    if (bufful < 6)
      return;

    bp = bigbuf;
    i = bufful;

    bp++;
    i--;
    while (i) {
      if (*bp == 0x10 || *bp == '*')
        break;
      if (*bp == '$') {
        memcpy(bigbuf, bp, i);
        bp = bigbuf;
        bufful = i;
      }
      bp++;
      i--;
    }

    if (!i)
      return;

    bufful = --i;
    *bp++ = 0;

    //    WinDrawChars(bigbuf,strlen(bigbuf),0,140);

    if (decgps(&bigbuf[1]))
      WinDrawChars(bigbuf, strlen(bigbuf), 0, 150);

    bigbuf[0] = 0;
    if (!i)
      break;

    memcpy(bigbuf, bp, i);
  }

}

DWord PilotMain(Word cmd, Ptr cmdPBP, Word launchFlags)
{
  short err;
  EventType event;

  if (cmd != sysAppLaunchCmdNormalLaunch)
    return 0;

  setup();

  do {
    EvtGetEvent(&event, 0);
    EvtResetAutoOffTimer();
    doser();
    if (event.eType == nilEvent)
      continue;

    if (SysHandleEvent(&event))
      continue;
    if (MenuHandleEvent((void *) 0, &event, &err))
      continue;
  } while (event.eType != appStopEvent);

  teardown();
  return 0;
}
