/*
 * FILE:
 * teststrip.c
 *
 * FUNCTION:
 * Simple test-case for the strip chart widget.
 *
 * HISTORY:
 * Created by Linas Vepstas February 2002
 */

#include <math.h>
#include <stdlib.h>
#include <gtk/gtk.h>

#include "gtkstripchart.h"

void
add_data (GtkStripChartChart *chart)
{
  int i;
  int npts = 20;
  gdouble *xpts, *ypts;
  gdouble dr, th, d, s;
  static int angle = 0;

  xpts = g_new (gdouble, npts);
  ypts = g_new (gdouble, npts);

  s = sin (M_PI * angle/180.0);
  s += 1.0;
  s *= 0.5;
  s = 0.6 + 1.38*s;
  d = s / ((double) npts);
  th = 1.0;
  for (i=0; i<npts; i++)
  {
    xpts[i] = 31*365*24*3600 + 3*24*3600*i;
    ypts[i] = th;
    dr = ((double) rand ()) / ((double) RAND_MAX);
    dr *= d;
    th -= dr;
  }

  gtk_strip_chart_chart_add_strip (chart, npts, xpts, ypts);

  angle += 36;
}

int 
main(int argc, char *argv[])
{
  GtkStripChartChart *chart;
  GdkColor color;
  GtkWidget *main_w, *vbox_w, *scroll_w, *chart_w;

  gtk_init(&argc,&argv);
  
  /* Generic window setup --
   * The next block is plain-old 'typical' GTK setup code */
  main_w = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW(main_w), "Strip Chart Demo");
  gtk_widget_set_usize (main_w,450,550);
  // gtk_container_border_width(GTK_CONTAINER(main_w),0);

  gtk_signal_connect (GTK_OBJECT (main_w), "destroy",
 		     GTK_SIGNAL_FUNC (gtk_main_quit), NULL);

  vbox_w = gtk_vbox_new(FALSE,0);
  gtk_container_add (GTK_CONTAINER(main_w),vbox_w);
  gtk_widget_show (vbox_w);

  scroll_w = gtk_scrolled_window_new(NULL, NULL);
  gtk_container_border_width (GTK_CONTAINER(scroll_w),0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW(scroll_w),
				 GTK_POLICY_ALWAYS,GTK_POLICY_ALWAYS);
  gtk_box_pack_start(GTK_BOX(vbox_w),scroll_w, TRUE, TRUE,0);
  gtk_widget_show(scroll_w);


  /* Create a strip chart, put it in the demo window */
  chart_w = gtk_strip_chart_chart_new ();
  gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scroll_w), chart_w);

  gtk_widget_show(chart_w);
  gtk_widget_show(main_w);

  chart = GTK_STRIP_CHART_CHART (chart_w);

  /* Override some strip chart attributes */
  gdk_color_parse("black", &color);
  chart->override_symbol_border_color = 0;
  chart->symbol.symbol_type = GTK_PLOT_SYMBOL_DIAMOND;
  chart->symbol.size = 8;
  chart->symbol.border.color = color;

  chart->title = "This is Only a Test.";

  add_data (chart);
  add_data (chart);
  add_data (chart);

  gtk_strip_chart_chart_set_range (chart, 0.0, 1.0);

  gdk_color_parse("red", &color);
  gtk_strip_chart_chart_add_limit (chart, 0.25, color);
  gdk_color_parse("cyan", &color);
  gtk_strip_chart_chart_add_limit (chart, 0.4, color);
  gdk_color_parse("green", &color);
  gtk_strip_chart_chart_add_limit (chart, 0.6, color);
  gtk_strip_chart_chart_set_xrange (chart, 
    31*365*24*3600+ 6*24*3600, 
    31*365*24*3600 + 3*24*3600*20 + 6*24*3600);

  printf ("\n************************************\n");
  printf ("Use the arrow keys to zoom and scroll\n");
  printf ("\n************************************\n");

  gtk_main ();

  exit (0);
}

