/*
 * FILE:
 * gtkstripchartlimit.c
 *
 * FUNCTION:
 * Limit range for the strip chart
 *
 * HISTORY:
 * Lins Vepstas February 2002
 */

#include "gtkstripchartlimit.h"

/* ========================================================== */

/* class methods */
static void gtk_strip_chart_limit_class_init (GtkStripChartLimitClass *);
static void gtk_strip_chart_limit_init (GtkStripChartLimit *);
static void gtk_strip_chart_limit_destroy (GtkObject *object);


/* ========================================================== */

GtkType	
gtk_strip_chart_limit_get_type (void)
{
  static GtkType lim_type = 0;

  if (!lim_type)
    {
      GtkTypeInfo lim_info =
      {
        "GtkStripChartLimit",
        sizeof (GtkStripChartLimit),
        sizeof (GtkStripChartLimitClass),
        (GtkClassInitFunc) gtk_strip_chart_limit_class_init,
        (GtkObjectInitFunc) gtk_strip_chart_limit_init,
        /* reserved 1*/ NULL,
        /* reserved 2 */ NULL,
        (GtkClassInitFunc) NULL,
      };

      lim_type = gtk_type_unique (gtk_plot_data_get_type(), &lim_info);
    }
  return lim_type;

}

/* ========================================================== */

static void
gtk_strip_chart_limit_class_init (GtkStripChartLimitClass *klass)
{
  GtkObjectClass *object_class;

  object_class = (GtkObjectClass *) klass;

  object_class->destroy = gtk_strip_chart_limit_destroy;
}

/* ========================================================== */

static void
set_color (GtkStripChartLimit *lim)
{
  gtk_plot_data_set_symbol(&lim->plot_data,
                             GTK_PLOT_SYMBOL_NONE,
                             GTK_PLOT_SYMBOL_EMPTY,
                             1, 1.0, &lim->range_color, 
                             &lim->range_color);
#if (0 == GTKEXTRA_MAJOR_VERSION) && \
    (99 == GTKEXTRA_MINOR_VERSION) && \
    (17 >= GTKEXTRA_MICRO_VERSION)
  gtk_plot_data_set_line_attributes(&lim->plot_data,
                             GTK_PLOT_LINE_DOT_DOT_DASH,
                             1.0, &lim->range_color);
#else
  gtk_plot_data_set_line_attributes(&lim->plot_data,
                             GTK_PLOT_LINE_DOT_DOT_DASH,
                             GDK_CAP_BUTT,
                             GDK_JOIN_MITER,
                             1.0, &lim->range_color);
#endif
}

static void
gtk_strip_chart_limit_init (GtkStripChartLimit *lim)
{

  gtk_strip_chart_limit_set_range (lim, 0.0);
  lim->line_x[0] = -1.0e30;
  lim->line_x[1] = +1.0e30;

  gdk_color_parse("red", &lim->range_color);
  gdk_color_alloc(gdk_colormap_get_system(), &lim->range_color);

  lim->range_fill = 0;

  set_color (lim);

  gtk_plot_data_set_points (&lim->plot_data, 
                            lim->line_x, lim->line_y, 
                            NULL, NULL, 2);

}

/* ========================================================== */

GtkWidget *
gtk_strip_chart_limit_new (void)
{
  GtkStripChartLimit *lim;

  lim = gtk_type_new (gtk_strip_chart_limit_get_type ());

  return GTK_WIDGET (lim);
}

/* ========================================================== */

static void 
gtk_strip_chart_limit_destroy (GtkObject *object)
{
  // GtkStripChartLimit *lim;

  g_return_if_fail (object != NULL);
  g_return_if_fail (GTK_IS_STRIP_CHART_LIMIT (object));

}

/* ========================================================== */

void
gtk_strip_chart_limit_set_range (GtkStripChartLimit *lim, 
                                 gdouble ymax)
{
  g_return_if_fail (NULL != lim);
  g_return_if_fail (GTK_IS_STRIP_CHART_LIMIT (lim));
  lim->range_max = ymax;
  lim->line_y[0] = ymax;
  lim->line_y[1] = ymax;
}

/* ========================================================== */

void
gtk_strip_chart_limit_set_color (GtkStripChartLimit *lim, 
                                 GdkColor col)
{
  g_return_if_fail (NULL != lim);
  g_return_if_fail (GTK_IS_STRIP_CHART_LIMIT (lim));

  gdk_colormap_free_colors (gdk_colormap_get_system(), 
                           &lim->range_color, 1);
  lim->range_color = col;
  
  gdk_color_alloc(gdk_colormap_get_system(), &lim->range_color);

  set_color (lim);
}

/* ========================================================== */

void
gtk_strip_chart_limit_set_width (GtkStripChartLimit *lim, 
                                 gdouble xmin, gdouble xmax)
{
  g_return_if_fail (NULL != lim);
  g_return_if_fail (GTK_IS_STRIP_CHART_LIMIT (lim));
  lim->line_x[0] = xmin;
  lim->line_x[1] = xmax;
}

/* ======================== END OF FILE ===================== */
