
/*
 * FILE:
 * gtkstripchartcursorset.h
 *
 * FUNCTION:
 * GTK widget that defines a collection of cursors.  Normally, a cursor
 * can only be a part of one strip; and thus managing a bunch of strips
 * (i.e. a bunch of cursors) is a pain.   This widget is a kind-of 'wrapper'
 * widget that is handy for setting attributes on all of them at once.
 *
 * HISTORY:
 * Linas Vepstas February 2002
 */

#ifndef GTK_STRIP_CHART_CURSOR_SET_H 
#define GTK_STRIP_CHART_CURSOR_SET_H 

#include <time.h>
#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include <gtkextra/gtkplotcanvas.h>

#include "gtkstripchartcursor.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/* ------------------------------------------------ */

#define GTK_TYPE_STRIP_CHART_CURSOR_SET	(gtk_strip_chart_cursor_set_get_type())
#define GTK_STRIP_CHART_CURSOR_SET(obj) 	(GTK_CHECK_CAST ((obj), GTK_TYPE_STRIP_CHART_CURSOR_SET, GtkStripChartCursorSet))
#define GTK_STRIP_CHART_CURSOR_SET_CLASS(klass) ((GTK_CHECK_CLASS_CAST ((klass), GTK_TYPE_STRIP_CHART_CURSOR_SET, GtkStripChartCursorSetClass))

#define GTK_IS_STRIP_CHART_CURSOR_SET(obj)	(GTK_CHECK_TYPE ((obj), GTK_TYPE_STRIP_CHART_CURSOR_SET))
#define GTK_IS_STRIP_CHART_CURSOR_SET_CLASS(klass)	(GTK_CHECK_CLASS_TYPE ((klass), GTK_TYPE_STRIP_CHART_CURSOR_SET))

/* ------------------------------------------------ */

typedef GList GtkStripChartCursorSetList;

struct _GtkStripChartCursorSet 
{
  GtkPlotData plot_data;

  gdouble   x_position;
  gboolean  dragable;

  GtkStripChartCursorList * drag_list; /* other cursors that drag with this one.  */

};

struct _GtkStripChartCursorSetClass
{
  GtkPlotDataClass parent_class;
};


GtkType    gtk_strip_chart_cursor_set_get_type  (void);
GtkWidget *gtk_strip_chart_cursor_set_new    (void);

/* Add a cursor to the set */
void       gtk_strip_chart_cursor_set_add_cursor (GtkStripChartCursorSet *, 
                                            GtkStripChartCursor *);

/* Set the position 
 * Sets the postion for all cursors in this set.
 */
void       gtk_strip_chart_cursor_set_set_pos (GtkStripChartCursorSet *, 
                                               gdouble pos);


/* Set the height 
 * Sets the height for all cursors in this set.
 */
void       gtk_strip_chart_cursor_set_set_height (GtkStripChartCursorSet *, 
                                        gdouble ymin, gdouble ymax);
/* Mark the set as draggable or not.
 * Sets the dragable boolean for all cursors in this set.
 */

void      gtk_strip_chart_cursor_set_set_dragable (GtkStripChartCursorSet *, 
                                        gboolean dragable);

/* Same as gtk_plot_data_set_symbol() except that it affects all cursors.
 * Basically, this will set a symbol at the top and bottom of each cursor:
 * handy for giving cursors some pizzaz, since normally a cursor is just
 * a plain-old vertical line.
 */
void      gtk_strip_chart_cursor_set_set_symbol (GtkStripChartCursorSet *, 
                                                 GtkPlotSymbolType type,
                                                 GtkPlotSymbolStyle style,
                                                 gint size,
                                                 gfloat line_width,
                                                 const GdkColor *color,
                                                 const GdkColor *border_color);


/* Add a text label.  This text label will only get added to the topmost
 *    cursor in the set (thus hopefully avoiding screen clutter).
 */
void       gtk_strip_chart_cursor_set_set_text (GtkStripChartCursorSet *,
                                                 const gchar *text);

void       gtk_strip_chart_cursor_set_set_text_attributes (GtkStripChartCursorSet *,
                                            const gchar * font_name,
                                            gint font_size,
                                            gint text_angle,
                                            const GdkColor *fg_color,
                                            const GdkColor *bg_color);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* GTK_STRIP_CHART_CURSOR_SET_H */
