/*
 * FILE:
 * gtkstripchartcursorset.c
 *
 * FUNCTION:
 * CursorSet for the strip chart
 *
 * HISTORY:
 * Lins Vepstas February 2002
 */

#include <gdk/gdkkeysyms.h>

#include "gtkstripchartcursorset.h"

/* ========================================================== */

/* class methods */
static void gtk_strip_chart_cursor_set_class_init (GtkStripChartCursorSetClass *);
static void gtk_strip_chart_cursor_set_init (GtkStripChartCursorSet *);
static void gtk_strip_chart_cursor_set_destroy (GtkObject *object);


/* ========================================================== */

GtkType	
gtk_strip_chart_cursor_set_get_type (void)
{
  static GtkType curs_type = 0;

  if (!curs_type)
    {
      GtkTypeInfo curs_info =
      {
        "GtkStripChartCursorSet",
        sizeof (GtkStripChartCursorSet),
        sizeof (GtkStripChartCursorSetClass),
        (GtkClassInitFunc) gtk_strip_chart_cursor_set_class_init,
        (GtkObjectInitFunc) gtk_strip_chart_cursor_set_init,
        /* reserved 1*/ NULL,
        /* reserved 2 */ NULL,
        (GtkClassInitFunc) NULL,
      };

      curs_type = gtk_type_unique (gtk_plot_data_get_type(), &curs_info);
    }
  return curs_type;

}

/* ========================================================== */

static void
gtk_strip_chart_cursor_set_class_init (GtkStripChartCursorSetClass *klass)
{
  GtkObjectClass *object_class;

  object_class = (GtkObjectClass *) klass;

  object_class->destroy = gtk_strip_chart_cursor_set_destroy;
}

/* ========================================================== */

static void
gtk_strip_chart_cursor_set_init (GtkStripChartCursorSet *curset)
{
  GdkColor color;

  curset->x_position = 0.0;
  curset->dragable = TRUE;
  curset->drag_list = NULL;

  /* set some default atrributes */
  gdk_color_parse("green", &color);
  gdk_color_alloc(gdk_colormap_get_system(), &color);

  gtk_plot_data_set_symbol(&curset->plot_data,
                             GTK_PLOT_SYMBOL_NONE,
                             GTK_PLOT_SYMBOL_EMPTY,
                             1, 1.0, &color, &color);
#if (0 == GTKEXTRA_MAJOR_VERSION) && \
    (99 == GTKEXTRA_MINOR_VERSION) && \
    (17 >= GTKEXTRA_MICRO_VERSION)
  gtk_plot_data_set_line_attributes(&curset->plot_data,
                             GTK_PLOT_LINE_SOLID,
                             2.0, &color);
#else
  gtk_plot_data_set_line_attributes(&curset->plot_data,
                             GTK_PLOT_LINE_SOLID,
                             GDK_CAP_BUTT,
                             GDK_JOIN_MITER,
                             2.0, &color);
#endif

}

/* ========================================================== */

GtkWidget *
gtk_strip_chart_cursor_set_new (void)
{
  GtkStripChartCursorSet *curset;

  curset = gtk_type_new (gtk_strip_chart_cursor_set_get_type ());

  return GTK_WIDGET (curset);
}

/* ========================================================== */

static void 
gtk_strip_chart_cursor_set_destroy (GtkObject *object)
{
  // GtkStripChartCursorSet *curs;

  g_return_if_fail (object != NULL);
  g_return_if_fail (GTK_IS_STRIP_CHART_CURSOR_SET (object));

}

/* ========================================================== */

void
gtk_strip_chart_cursor_set_set_pos (GtkStripChartCursorSet *curset, gdouble pos)
{
  GList *node;

  g_return_if_fail (NULL != curset);
  curset->x_position = pos;

  for (node=curset->drag_list; node; node=node->next)
  {
    GtkStripChartCursor *curs = node->data;
    gtk_strip_chart_cursor_set_pos (curs, pos);
  }
}

/* ========================================================== */

void
gtk_strip_chart_cursor_set_set_height (GtkStripChartCursorSet *curset, 
                                   gdouble ymin, gdouble ymax)
{
  GList *node;

  g_return_if_fail (NULL != curset);
  for (node=curset->drag_list; node; node=node->next)
  {
    GtkStripChartCursor *curs = node->data;
    gtk_strip_chart_cursor_set_height (curs, ymin, ymax);
  }
}

/* ========================================================== */

void
gtk_strip_chart_cursor_set_set_symbol (GtkStripChartCursorSet *curset, 
                                       GtkPlotSymbolType type,
                                       GtkPlotSymbolStyle style,
                                       gint size,
                                       gfloat line_width,
                                       const GdkColor *color,
                                       const GdkColor *border_color)
{
  GList *node;
  GtkPlotData *pld;

  g_return_if_fail (NULL != curset);

  pld = GTK_PLOT_DATA(curset);

  gtk_plot_data_set_symbol (pld, type, style, size, line_width,
                            color, border_color);

  for (node=curset->drag_list; node; node=node->next)
  {
    GtkStripChartCursor *curs = node->data;
    pld = GTK_PLOT_DATA(curs);
    gtk_plot_data_set_symbol (pld, type, style, size, line_width,
                            color, border_color);

  }
}

/* ========================================================== */

void
gtk_strip_chart_cursor_set_set_dragable (GtkStripChartCursorSet *curset, 
                                   gboolean drag)
{
  GList *node;

  g_return_if_fail (NULL != curset);
  for (node=curset->drag_list; node; node=node->next)
  {
    GtkStripChartCursor *curs = node->data;
    gtk_strip_chart_cursor_set_dragable (curs, drag);
  }
}

/* ========================================================== */

void
gtk_strip_chart_cursor_set_add_cursor (GtkStripChartCursorSet *curset,
                                 GtkStripChartCursor *dragee)
{
  GtkPlotLineStyle line_style;
  gfloat line_width;
  GdkColor color, border_color;
  GtkPlotData *pld_set, *pld;
  GtkPlotSymbolType sym_type;
  GtkPlotSymbolStyle sym_style;
  gint size;

  g_return_if_fail (NULL != curset);

  curset->drag_list = g_list_append (curset->drag_list, dragee);
  dragee->cursor_set = curset;

  /* propagate attributes to the individual cursors */
  gtk_strip_chart_cursor_set_pos (dragee, curset->x_position);
  gtk_strip_chart_cursor_set_dragable (dragee, curset->dragable);

  pld_set = GTK_PLOT_DATA(curset);
  pld = GTK_PLOT_DATA(dragee);

#if (0 == GTKEXTRA_MAJOR_VERSION) && \
    (99 == GTKEXTRA_MINOR_VERSION) && \
    (17 >= GTKEXTRA_MICRO_VERSION)
  gtk_plot_data_get_line_attributes   (pld_set,
                      &line_style, &line_width, &color);

  gtk_plot_data_set_line_attributes(pld,
                                    line_style,
                                    line_width,
                                    &color);
#else
  {
     GdkJoinStyle join_style;
     GdkCapStyle cap_style;
     gtk_plot_data_get_line_attributes   (pld_set,
              &line_style, &cap_style, &join_style, &line_width, &color);

     gtk_plot_data_set_line_attributes(pld,
                                    line_style,
                                    cap_style,
                                    join_style,
                                    line_width,
                                    &color);
  }
#endif

  gtk_plot_data_get_symbol  (pld_set, &sym_type, &sym_style, &size,
                             &line_width, &color, &border_color);

  gtk_plot_data_set_symbol  (pld, sym_type, sym_style, size,
                             line_width, &color, &border_color);


}

/* ========================================================== */

void
gtk_strip_chart_cursor_set_set_text (GtkStripChartCursorSet *curset,
                                 const gchar *text)
{
  GtkStripChartCursor *curs;
  
  g_return_if_fail (NULL != curset);
  if (!curset->drag_list) return;
  
  curs = curset->drag_list->data;
  gtk_strip_chart_cursor_set_text (curs, text);
}

void
gtk_strip_chart_cursor_set_set_text_attributes (GtkStripChartCursorSet *curset,
                                            const gchar * font_name,
                                            gint font_size,
                                            gint text_angle,
                                            const GdkColor *fg_color,
                                            const GdkColor *bg_color)
{
  GtkStripChartCursor *curs;
  
  g_return_if_fail (NULL != curset);
  if (!curset->drag_list) return;
  
  curs = curset->drag_list->data;

  gtk_strip_chart_cursor_set_text_attributes (curs, font_name, font_size, 
                  text_angle, fg_color, bg_color);
}


/* ======================== END OF FILE ===================== */
