/*
 * FILE:
 * gtkstripchartcursor.c
 *
 * FUNCTION:
 * Cursor for the strip chart
 *
 * HISTORY:
 * Lins Vepstas February 2002
 */

#include <gdk/gdkkeysyms.h>

#include "gtkstripchartcursor.h"

/* ========================================================== */

/* class methods */
static void gtk_strip_chart_cursor_class_init (GtkStripChartCursorClass *);
static void gtk_strip_chart_cursor_init (GtkStripChartCursor *);
static void gtk_strip_chart_cursor_destroy (GtkObject *object);


/* ========================================================== */

GtkType
gtk_strip_chart_cursor_get_type (void)
{
  static GtkType curs_type = 0;

  if (!curs_type)
    {
      GtkTypeInfo curs_info =
      {
        "GtkStripChartCursor",
        sizeof (GtkStripChartCursor),
        sizeof (GtkStripChartCursorClass),
        (GtkClassInitFunc) gtk_strip_chart_cursor_class_init,
        (GtkObjectInitFunc) gtk_strip_chart_cursor_init,
        /* reserved 1*/ NULL,
        /* reserved 2 */ NULL,
        (GtkClassInitFunc) NULL,
      };

      curs_type = gtk_type_unique (gtk_plot_data_get_type(), &curs_info);
    }
  return curs_type;

}

/* ========================================================== */

static void
gtk_strip_chart_cursor_class_init (GtkStripChartCursorClass *klass)
{
  GtkObjectClass *object_class;
  GtkWidgetClass *widget_class;

  object_class = (GtkObjectClass *) klass;
  widget_class = (GtkWidgetClass *) klass;

  // widget_class->draw = gtk_strip_chart_cursor_draw;

  // widget_class->show_all = gtk_strip_chart_cursor_show_all;

  object_class->destroy = gtk_strip_chart_cursor_destroy;
}

/* ========================================================== */

static void
gtk_strip_chart_cursor_init (GtkStripChartCursor *curs)
{
  GdkColor color, fg_color, bg_color;

  gtk_strip_chart_cursor_set_pos (curs, 0.0);
  curs->ypos[0] = -1.0e30;
  curs->ypos[1] = +1.0e30;

  gdk_color_parse("green", &color);
  gdk_color_alloc(gdk_colormap_get_system(), &color);

  gtk_plot_data_set_symbol(&curs->plot_data,
                             GTK_PLOT_SYMBOL_NONE,
                             GTK_PLOT_SYMBOL_EMPTY,
                             1, 1.0, &color, &color);
#if (0 == GTKEXTRA_MAJOR_VERSION) && \
    (99 == GTKEXTRA_MINOR_VERSION) && \
    (17 >= GTKEXTRA_MICRO_VERSION)
  gtk_plot_data_set_line_attributes(&curs->plot_data,
                             GTK_PLOT_LINE_SOLID,
                             2.0, &color);
#else
  gtk_plot_data_set_line_attributes(&curs->plot_data,
                             GTK_PLOT_LINE_SOLID,
                             GDK_CAP_BUTT,
                             GDK_JOIN_MITER,
                             2.0, &color);
#endif

  gtk_plot_data_set_points (&curs->plot_data, 
                            curs->xpos, curs->ypos, 
                            NULL, NULL, 2);


  gdk_color_parse("black", &fg_color);
  gdk_color_alloc(gdk_colormap_get_system(), &fg_color);
	 
  gdk_color_parse("white", &bg_color);
  gdk_color_alloc(gdk_colormap_get_system(), &bg_color);
	 
  gtk_plot_data_labels_set_attributes (&curs->plot_data, 
						"Helvetica", 12, 0, &fg_color, &bg_color);
  
  gtk_plot_data_show_labels (&curs->plot_data, FALSE);

  curs->strip      = NULL;
  curs->cursor_set = NULL;

  /* cursor label stuff */
  curs->label_text = NULL;
  curs->labs[1] = curs->label_text;
  curs->labs[0] = "";
}

/* ========================================================== */

GtkWidget *
gtk_strip_chart_cursor_new (void)
{
  GtkStripChartCursor *curs;

  curs = gtk_type_new (gtk_strip_chart_cursor_get_type ());

  return GTK_WIDGET (curs);
}

/* ========================================================== */

static void 
gtk_strip_chart_cursor_destroy (GtkObject *object)
{
  // GtkStripChartCursor *curs;

  g_return_if_fail (object != NULL);
  g_return_if_fail (GTK_IS_STRIP_CHART_CURSOR (object));

}

/* ========================================================== */

void
gtk_strip_chart_cursor_set_pos (GtkStripChartCursor *curs, gdouble pos)
{
  g_return_if_fail (NULL != curs);
  curs->x_position = pos;
  curs->xpos[0] = pos;
  curs->xpos[1] = pos;
}

/* ========================================================== */

void
gtk_strip_chart_cursor_set_height (GtkStripChartCursor *curs, 
                                   gdouble ymin, gdouble ymax)
{
  g_return_if_fail (NULL != curs);
  curs->ypos[0] = ymin;
  curs->ypos[1] = ymax;
}

/* ========================================================== */

void
gtk_strip_chart_cursor_set_dragable (GtkStripChartCursor *curs, 
                                     gboolean drag)
{
  g_return_if_fail (NULL != curs);
  curs->dragable = drag;
}

/* ========================================================== */

void
gtk_strip_chart_cursor_set_text (GtkStripChartCursor *curs,
                                 const gchar *text)
{
  g_return_if_fail (NULL != curs);
  g_free (curs->label_text);
  curs->label_text = g_strdup (text);
  curs->labs[0] = "";
  curs->labs[1] = curs->label_text;
  
  if (curs->label_text)
  {
    gtk_plot_data_set_labels (&curs->plot_data, curs->labs);
    gtk_plot_data_show_labels (&curs->plot_data, TRUE);
  }
}

void
gtk_strip_chart_cursor_set_text_attributes (GtkStripChartCursor *curs,
                                 const gchar * font_name,
                                 gint font_size,
                                 gint text_angle,
                                 const GdkColor *fg_color,
                                 const GdkColor *bg_color)
{
  g_return_if_fail (NULL != curs);
  
  gtk_plot_data_labels_set_attributes (&curs->plot_data, 
						font_name, font_size, text_angle, fg_color, bg_color);
  
}

/* ======================== END OF FILE ===================== */
