/*************************************************************************
 *
 * tester.c
 *
 * LOMAC - Low Water-Mark Mandatory Access Control for Linux 
 * Copyright (C) 1999, 2000 NAI Labs
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2 of the GNU General Public
 * License as published by the Free Software Foundation.  This program
 * is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
 * License for more details.  You should have received a copy of the
 * GNU General Public License along with this program; if not, write
 * to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * This file contains the main program of a user-space PLM test utility.
 *
 *************************************************************************/

#include <stdio.h>

#include "lomac_level.h"
#include "lomac_plm.h"

int main( int argc, char *argv[] ) {

  level_t level;

  if( argc != 2 ) {
    fprintf( stderr, "USAGE: test_plm <path>\n" );
    exit( -1 );
  }

#ifdef PARANOID
  check_plm_constraints();
#endif

  get_pathname_level( argv[ 1 ], &level );

  printf( "%d\n", level );

  return( level );

} /* main() */

