#########################################################################
#
# LOMAC - Low Water-Mark Mandatory Access Control for Linux 
# Copyright (C) 1999 TIS Labs at Network Associates, Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of version 2 of the GNU General Public
# License as published by the Free Software Foundation.  This program
# is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or
# FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
# License for more details.  You should have received a copy of the
# GNU General Public License along with this program; if not, write
# to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.
#
# This module contains a number of common predicates that are useful
# to LOMAC test scripts.
#
# To use, put this in your Perl test script:
# use lomacpred;
#
#########################################################################

package lomacpred;   # I am package "lomacpred"
use Exporter ();     # I depend Exporter, but don't import any Exporter symbols
@ISA = qw(Exporter); # I'm an Exporter, and inherit Exporter's import() method
@EXPORT = (ProcAtLevelPred, FileAtLevelPred);  # I export these symbols


#########################################################################
#
# Subroutine ProcAtLevelPred
#
# Parms:
# $_[ 0 ]   level we expect to be at
#
# Return:   1 if we (that is, this process) is running at the level
#           indicated by $_[ 0 ], otherwise 0.
#
#########################################################################

sub ProcAtLevelPred {
        local($requested_level) = pop(@_);
        local($our_level);

        # Use the level program to determine our level.  $$ means our pid.
        open( LEVELOUT, "/opt/lomac/bin/level -p $$|" );
        $our_level = <LEVELOUT>;
	close( LEVELOUT );
        chop( $our_level );

        return( $our_level == $requested_level );
}


#########################################################################
#
# Subroutine FileAtLevelPred
#
# Parms:
# $_[ 0 ]   filename whose level we want to check
# $_[ 1 ]   level we expect the file to be at
#
# Return:   1 if the file indicated by $_[ 0 ] is at the level
#           indicated by $_[ 1 ], otherwise 0.
#
#########################################################################

sub FileAtLevelPred {
	local($file_level) = pop(@_);
	local($filename) = pop(@_);
	local($level);

	# Use the level program to determine the file's level.
	open( LEVELOUT, "/opt/lomac/bin/level -f $filename|" );
	$level = <LEVELOUT>;
	close( LEVELOUT );
	chop( $level );

	return( $level == $file_level );
}
