#ifndef _LOMAC_MEDIATE_H_
#define _LOMAC_MEDIATE_H_

/*************************************************************************
 *
 * lomac_mediate.h
 *
 * LOMAC - Low Water-Mark Mandatory Access Control for Linux 
 * Copyright (C) 1999, 2000 NAI Labs
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2 of the GNU General Public
 * License as published by the Free Software Foundation.  This program
 * is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
 * License for more details.  You should have received a copy of the
 * GNU General Public License along with this program; if not, write
 * to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 *
 *************************************************************************/

#include "kernel_interface.h"

int mediate_pgrp_change( lomac_subject_t *p_src_subject, 
			 lomac_subject_t *p_dest_subject );
int mediate_open( lomac_subject_t *p_subject, const char *path_s );
int mediate_write( lomac_subject_t *p_subject, lomac_object_t *p_object );
int mediate_rename( lomac_subject_t *p_subject, const char *canabsoldname_s,
		    const char *canabsnewname_s );
int mediate_link( lomac_subject_t *p_subject, const char *canabsoldname_s,
		  const char *canabsnewname_s );
int mediate_kill( lomac_subject_t *p_subject, lomac_subject_t *p_target );
int mediate_is_highest( lomac_subject_t *p_subject, char *operation_s );

#endif
