#ifndef _LOMAC_LOG_H_
#define _LOMAC_LOG_H_

/***************************************************************************
 *
 * lomac_log.h
 *
 * LOMAC - Low Water-Mark Mandatory Access Control for Linux 
 * Copyright (C) 1999, 2000 NAI Labs
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2 of the GNU General Public
 * License as published by the Free Software Foundation.  This program
 * is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
 * License for more details.  You should have received a copy of the
 * GNU General Public License along with this program; if not, write
 * to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 *
 * This file contains the public interface to LOMAC's log functions
 *
 *
 ***************************************************************************/

#include "kernel_interface.h"

/* All log fxns share this common log buffer.  Some functions also *
 * use this buffer for scratch space.                              */
extern char log_s[];

/* Use this unsigned int and its constants to set the log output  *
 * verbosity.  Use of the log_* functions should be surrounded by *
 * if statements of the form "if( verbose & VERBOSE_FOO )" where  *
 * VERBOSE_FOO is the constant below which corresponds to the     *
 * type of event you're logging.                                  */
extern unsigned int verbose;
#define VERBOSE_NOLOG       0x00000000 /* no log output, please. */
#define VERBOSE_DEMOTE_DENY 0x00000001 /* log demotions and access denials. */
#define VERBOSE_PIPE        0x00000002 /* log changes to pipe "levels". */
#define VERBOSE_LOG_PGRPS   0x00000004 /* log pgrp creation and management. */
#define VERBOSE_LOG_SOCKETS 0x00000008 /* log UNIX domain socket setup. */
#define VERBOSE_LOG_OBJECTS 0x00000010 /* log opening of objects. */
#ifdef TRUST
#define VERBOSE_TRUST       0x00000020 /* log when trust stops demotion. */
#endif

void log_start( void );
void log_append_string( const char *data_s );
void log_append_int( int data );
void log_append_subject_id( lomac_subject_t *p_subject );
void log_append_object_id( lomac_object_t *p_object );
void log_print( void );

#endif
