#ifndef _LOMAC_LEVEL_H_
#define _LOMAC_LEVEL_H_

/***************************************************************************
 *
 * LOMAC - Low Water-Mark Mandatory Access Control for Linux 
 * Copyright (C) 1999, 2000 NAI Labs
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2 of the GNU General Public
 * License as published by the Free Software Foundation.  This program
 * is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
 * License for more details.  You should have received a copy of the
 * GNU General Public License along with this program; if not, write
 * to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * This file defines the level_t type.  Right now, this is just an  
 * unsigned int, but later on, we may expand it into a small struct 
 * containing whatever level-related fields we need.  This version  
 * of LOMAC supports only two levels.                               
 *
 ***************************************************************************/

#define LOMAC_HIGHEST_LEVEL 2
#define LOMAC_LOWEST_LEVEL  1
#define LOMAC_INVALID_LEVEL 0

#define LEVEL_LEQ( a, b )( (a) <= (b) )

typedef unsigned int level_t;

#ifdef PARANOID
int is_well_formed_level( level_t *p_level );
#endif /* PARANOID */


#endif
