/***************************************************************************
 *
 * lomac_level.c
 *
 * LOMAC - Low Water-Mark Mandatory Access Control for Linux 
 * Copyright (C) 1999, 2000 NAI Labs
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2 of the GNU General Public
 * License as published by the Free Software Foundation.  This program
 * is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
 * License for more details.  You should have received a copy of the
 * GNU General Public License along with this program; if not, write
 * to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 *
 * This file contains routines for examining level_t objects 
 *
 *
 ***************************************************************************/




#include "lomac_level.h"

#ifdef PARANOID

/* is_well_formed_level()
 *
 * in:     p_level - pointer to the level object to examine
 * out:    nothing
 * return: value    condition
 *         -----    ---------
 *           1      `p_level' points to a well-formed level object
 *           2      `p_level' points to a mal-formed level object
 *
 */

int is_well_formed_level( level_t *p_level ) {

  if( ( *p_level < LOMAC_LOWEST_LEVEL ) ||
      ( *p_level > LOMAC_HIGHEST_LEVEL ) ) {
    return( 0 );
  }
  return( 1 );

} /* is_well_formed_level() */

#endif /* PARANOID */
