#ifndef _KERNEL_UTIL_H_
#define _KERNEL_UTIL_H_

/***************************************************************************
 *
 * kernel_util.h
 *
 * LOMAC - Low Water-Mark Mandatory Access Control for Linux 
 * Copyright (C) 1999, 2000 NAI Labs
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2 of the GNU General Public
 * License as published by the Free Software Foundation.  This program
 * is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
 * License for more details.  You should have received a copy of the
 * GNU General Public License along with this program; if not, write
 * to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 *
 *
 *
 *
 ***************************************************************************/

#include <linux/sched.h>   /* for `current' process, struct task */
#include <linux/fs.h>      /* for inode, dentry, file, iovec structures */


/* Here's a macro to identify objects that are (unnamed) pipes.        *
 * In the 2.0 kernel, we could check to see if `p_lvnode->i_pipe' is   *
 * set.  Unfortunately, the 2.2 kernel's get_pipe_inode() function     *
 * forgets to set this flag.  So, we identify pipes/fifos with the     *
 * S_IFIFO flag, and distinguish between the two by their i_op fields. */
#define IS_PIPE( p_pipe ) \
     ( (p_pipe) && \
       (p_pipe)->d_inode && \
       (p_pipe)->d_inode->i_mode & S_IFIFO && \
       (p_pipe)->d_inode->i_op != &fifo_inode_operations )

/* Here's macros to identify objects which are local and non-local *
 * sockets.                                                        */
#define IS_SOCKET( p_socket ) \
     ( (p_socket) && \
     (p_socket)->d_inode && \
     (p_socket)->d_inode->i_sock )

#define IS_LOCAL_SOCKET( p_socket ) \
     ( (p_socket) && \
     (p_socket)->d_inode && \
     (p_socket)->d_inode->i_sock && \
     (p_socket)->d_inode->u.socket_i.ops->family == PF_UNIX )

#define IS_NETWORK_SOCKET( p_socket ) \
     ( (p_socket) && \
     (p_socket)->d_inode && \
     (p_socket)->d_inode->i_sock && \
     (p_socket)->d_inode->u.socket_i.ops->family != PF_UNIX )


#define MAX_SOCK_ADDR 128 /* max length of sockaddr from linux/net/socket.c */

struct task_struct *pid_to_task( int pid ); 
struct task_struct *pgrp_to_task( int pgrp ); 
struct dentry *fd_to_dentry( unsigned long );
struct dentry *socket_peer( struct dentry *p_socket_dentry );
struct dentry *socket_name( struct dentry *p_socket_dentry );
int copy_sockaddr_to_kernel( void *p_user_sockaddr, int length, 
			     void *p_kernel_sockaddr );

#endif
