/*
 * FILE:
 * window.h
 *
 * FUNCTION:
 * Manage a data window on the screen.  This window may be
 * and 'input' or an 'output window (or both): acepting user input,
 * windowing results of queries.
 *
 * HISTORY:
 * Linas Vepstas March 2002
 */

#ifndef DUI_WINDOW_H
#define DUI_WINDOW_H

#include <gtk/gtkwidget.h>

#include "readfile.h"

DuiWindow * dui_window_new (const char *name, DuiInterface *);
void dui_window_destroy (DuiWindow *);

const char * dui_window_get_name (DuiWindow *);
DuiInterface *dui_window_get_interface (DuiWindow *);

/* this records the top-level widget for this window.
 * its typically a top-level window 
 * If is_app_main_window is set, then this window will be automatially
 * created on application startup.
 */
void dui_window_set_glade (DuiWindow *, const char * glade_xml_filepath, 
                           const char *root_widget, int is_app_main_window);


/* these routines indicate that a report and/or form 'live' in this window */
void dui_window_add_action (DuiWindow *, DuiAction *);
void dui_window_add_report (DuiWindow *, DuiReport *);
void dui_window_add_signal (DuiWindow *, DuiSignal *);

/* thin wrapper around glade_xml_get_widget() 
 * Gets the widget associated with the indicated name.
 */
GtkWidget * dui_window_get_widget (DuiWindow *, const char * widgetname);

/* cause this window to actually exist on the screen */
void dui_window_realize (DuiWindow *);

/* return non-zero value if the widget for this window exists */
int  dui_window_is_realized (DuiWindow *);

int dui_window_is_app_main_window (DuiWindow *);

#endif /* DUI_WINDOW_H */
