/*
 * FILE:
 * report.h
 *
 * FUNCTION:
 * Fill in widget values based on results of database query
 *
 * HISTORY:
 * Linas Vepstas March 2002
 */

#ifndef DUI_REPORT_H
#define DUI_REPORT_H

#include "window.h"
#include "dui-initdb.h"

DuiReport * dui_report_new (DuiWindow *, const char * name);
void dui_report_destroy (DuiReport *);

/* set the row iterator widget.  This widget must
 * somehow be capable of reporting multiple rows
 * (ie. must have a way of creating a new row)
 * The "name" is used to identify this row as the target of an action.
 * The widgetname must be in the scope of the gladefile:root_widget tree
 * If nest is non-zero, then the iterator must be capable of displaying
 * a tree.  'nest' is how far down the tree we are.  match_col
 * and match-field are used to determine the parent node of the tree:
 * children are inserted under the parent whose 'match_col' contains 
 * the value from the database 'match_field' or hash 'match_key' or
 * value 'match_value'.
 */
void dui_report_add_row (DuiReport *, const char *name, 
                        const char *widgetname, int nest,
                        int match_col, const char * match_field,
								const char * match_key, const char * match_value);

/* widget must not be null. Either field or value must not be null.
 * If field is not null, it must be a valid database field.
 * Otherwise the constant value is used.
 */
void dui_report_add_column (DuiReport *dsp, 
                            const char *widget_name, int column_num,
                            const char * datakey, const char * arg,
                            const char * field, const char * key,
                            const char * value, const char * filter);


void dui_report_do_realize (DuiReport *);
const char * dui_report_get_name (DuiReport *);

/* Pull data off the indicated connection and display it. 
 * The "row_name" argument is used to determine the order
 * in which heirarchical reports are filled in.
 * Returns a non-zero value if there was data and it was 
 * displayed.  If there was no data, then no GUI element
 * was displayed, and this retruns zero.
 */
int dui_report_show_data (DuiReport *, DuiDBRecordSet *, 
                           const char * row_name);

/* Set the most recent action that generated data for this window.
 * If this window need to be refreshed, then this action will be
 * used to refresh it.  The "row_name" argument allows this 
 * report to be the target of several actions, heirarchically nested.
 */
void dui_report_set_last_action (DuiReport *, DuiAction *, 
                                 const char *row_name);

void dui_report_refresh (DuiReport *);

#endif /* DUI_REPORT_H */
