/*
 * FILE:
 * readfile.h
 *
 * FUNCTION:
 * parse an XML file that specifies the glade-to-database coupling
 *
 * HISTORY:
 * Linas Vepstas March 2002
 */

#ifndef READFILE_H
#define READFILE_H


typedef struct DuiInterface_s DuiInterface;
typedef struct DuiWindow_s DuiWindow;
typedef struct DuiReport_s DuiReport;
typedef struct DuiAction_s DuiAction;
typedef struct DuiSignal_s DuiSignal;
typedef struct DuiFilter_s DuiFilter;

DuiInterface * dui_interface_new (void);
void dui_interface_destroy (DuiInterface *dui);

/* read in and parse the indicated filename.  It had better contain a 
 * valid dui description!
 */
void dui_interface_parse (DuiInterface *, const char * xml_filename);

/* this call will start making gui calls, and must be called only
 * after glade and gtk have been initialized.  The second argument,
 * "fatal_if_no_main", indicates whether or not its a fatal error
 * if no main wiindow was found.
 */
void dui_interface_realize (DuiInterface *, int fatal_if_no_main);

/* scan the list of reports in this interface, and return the one with the 
 * indicated name 
 */
DuiReport * dui_interface_find_report_by_name (DuiInterface *, const char * name);
DuiAction * dui_interface_find_action_by_name (DuiInterface *, const char * name);
DuiWindow * dui_interface_find_window_by_name (DuiInterface *, const char * name);

/* insert a key-value pair into a hash table associated with this
 * interface. */
void dui_interface_kvp_insert (DuiInterface *, const char * key, 
                                             const char * value);

/* fetch the value assoicated with the key in the hash table */
const char * dui_interface_kvp_lookup (DuiInterface *, const char * key);


#endif /* READFILE_H */

