
/*
 * FILE:
 * perr.h
 *
 * FUNCTION:
 * Error message conduit.
 *
 * HISTORY:
 * Linas Vepstas March 2002
 */

#ifndef PERR_H
#define PERR_H

#ifndef G_LOG_DOMAIN
#define G_LOG_DOMAIN my_domain
static char * my_domain = "duude";
#endif

#include <stdio.h>
#include <glib.h>

typedef enum {
	LOG_FATAL,
	LOG_ERROR,
	LOG_WARN,
	LOG_INFO,
	LOG_DEBUG
} duiLogLevel;

static duiLogLevel log_level = LOG_WARN;

/* can't use g_error, its fatal :-( */
#define FATAL(fmt, args...)  \
	if (LOG_FATAL <= log_level) { g_error (__FUNCTION__ " " fmt, ## args); }

#define PERR(fmt, args...)  \
	if (LOG_ERROR <= log_level) { g_warning (__FUNCTION__ " " fmt, ## args); }

#define PWARN(fmt, args...) \
	if (LOG_WARN <= log_level) { g_warning (__FUNCTION__ " " fmt, ## args); }

#define PINFO(fmt, args...) \
	if (LOG_INFO <= log_level) { g_message (__FUNCTION__ " " fmt, ## args); }

#define ENTER(fmt, args...) \
	if (LOG_INFO <= log_level) { g_message ("Enter " __FUNCTION__ " " fmt, ## args); }

#define LEAVE(fmt, args...) \
	if (LOG_INFO <= log_level) { g_message ("Leave " __FUNCTION__ " " fmt, ## args); }


#define USERERR(fmt, args...) g_message (fmt "\n",   ## args);

#define SYNTAX(x,args...) USERERR ("Syntax Error: " x, ##args)

#endif /* PERR_H */

