/*
 * FILE:
 * filter.h
 *
 * FUNCTION: 
 * Provide a set of data filters that turn strings of one 
 * type into strings of another.
 *
 * HISTORY:
 * Linas Vepstas March 2002
 */

#ifndef DUI_FILTER_H
#define DUI_FILTER_H

#include "readfile.h"

DuiFilter * dui_filter_new (const char *name, const char *revname);

/* add to the lookup table */
void dui_filter_add_lookup (DuiFilter *, const char * key, const char * value);

DuiFilter * dui_filter_find_by_name (const char *);

/* apply the indicated filter to the string, returning the 
 * result string */
const char * dui_filter_apply (DuiFilter *, const char *);

/* return NULL if the field is whitespace (blank, tab, formfeed etc.)  */
const char * whitespace_filter (const char * val);

#endif /* DUI_FILTER_H */
