/*
 * FILE:
 * dwi-run.c
 *
 * FUNCTION:
 * Run the basic DWI interpreter.
 *
 * HISTORY:
 * Linas Vepstas March 2002
 */

#include <stdio.h>

#include <gnome.h>
#include <glade/glade.h>

#include "readfile.h"

#define VERSION "0.02"

/* =================================================================== */

int
main (int argc, char *argv[])
{
	char *dwi_file; 
	DuiInterface *di;

	if (2 > argc)
	{
		fprintf (stderr, "Usage: %s FILENAME.DUI\n", argv[0]);
		fprintf (stderr, "\tInterpret and run a DWI file\n");
		exit (1);
	} 

	dwi_file = argv[1];

	gnome_init ("main", VERSION, argc, argv);
	glade_gnome_init();

	di = dui_interface_new();
	dui_interface_parse (di, dwi_file);
	dui_interface_realize (di, TRUE);

	gtk_main ();

	dui_interface_destroy(di);
	printf ("Bye! Please Come Again!\n");

	return 0;
}

/* ========================== END OF FILE ============================ */
