/*
 * FILE:
 * database.c
 *
 * FUNCTION:
 * manage database connection info.
 *
 * HISTORY:
 * Linas Vepstas March 2002
 */

#include <string.h>
#include <stdlib.h>

#include <glib.h>

#include "perr.h"
#include "database.h"
#include "dui-initdb.h"

struct DuiDatabase_s 
{
	/* database info */
	char * provider;
	char * dbname;
	char * hostname;
	char * username;

	/* current database connection that is being used */
	DuiDBConnection *db_conn;
};

/* =================================================================== */

DuiDatabase *
dui_database_new (const char * provider, const char * dbname,
                  const char * hostname, const char * username)
{
	DuiDatabase *db;

	db = g_new (DuiDatabase, 1);
	db->provider = g_strdup (provider);
	db->dbname = g_strdup (dbname);
	db->hostname = g_strdup (hostname);
	db->username = g_strdup (username);

	db->db_conn = NULL;

	return db;
}

/* =================================================================== */
#if 0
dui_database_destroy () {
		     dui_connection_free (dui->db_conn);


#endif


/* =================================================================== */

DuiDBConnection *
dui_database_do_realize (DuiDatabase *db)
{
	
	if (!db) return NULL;
	if (db->db_conn) return db->db_conn;
	
	/* now actually open the database */
	db->db_conn = dui_connection_new (db->provider, db->dbname, db->username);
	if (NULL == db->db_conn)
	{
		FATAL ("can't open connection for provider=\"%s\", "
		       "database=\"%s\", username=\"%s\"",
              db->provider, db->dbname, db->username);
	}
	return db->db_conn;
}

/* ========================== END OF FILE ============================ */
