/*
 * FILE:
 * action.h
 *
 * FUNCTION:
 * handler for a button click.
 *
 * HISTORY:
 * Linas Vepstas March 2002
 */

#ifndef DUI_ACTION_H
#define DUI_ACTION_H

#include <glib.h>
#include <gtk/gtkobject.h>

#include "window.h"
#include "database.h"

DuiAction * dui_action_new (DuiWindow *parent, const char *name);
void dui_action_destroy (DuiAction *);

const char * dui_action_get_name (DuiAction *);

/* set the database connection that will be used to perfrom queries on */
void dui_action_set_database (DuiAction * act, DuiDatabase *db);
DuiDatabase * dui_action_get_database (DuiAction * act);


/* specify a signal that will invoke this action. 
 * The objectname must specify a GtkObject on which
 * there exists a signal of name 'signalname'
 */

void dui_action_add_signal (DuiAction *act, const char *objectname, const char *signalname);

/* specify the sql table that will be queried in this action.
 * querytype must be one of 'select', 'update', 'insert', 'delete', 
 * 'tables' or 'columns'.
 * 'key_to-tables' must specify a KVP key that contains a table name.
 */
void dui_action_set_table (DuiAction *, const char * tables, 
                                        const char * key_to_tables,
                                        const char * querytype);

void dui_action_add_select_term (DuiAction *, 
                                const char *field_name);

void dui_action_add_update_term (DuiAction *, 
                                const char *widgetname,
                                int column,
                                const char *datakey,
                                const char *key,
                                const char *value,
                                const char *filter_name,
                                const char *field_name);

void dui_action_add_where_term (DuiAction *, 
                                const char *widgetname,
                                int column,
                                const char *datakey,
                                const char *key,
                                const char *value,
                                const char *filter_name,
                                const char *field_name,
                                const char *compare_op);

void dui_action_add_kvp_term (DuiAction *, 
                                const char *widgetname,
                                int column,
                                const char *datakey,
                                const char *value,
                                const char *filter_name,
                                const char *key);


/* cross-reference to the windows that will show the results.
 * "row_name" is used to target multiple results to one report,
 * which is (for example) typically a columned tree. (GtkCTree)
 * */
void dui_action_set_report (DuiAction *, const char * name, 
                            const char * row_name);

/* add a window that needs to be refreshed when this action is performed */
void dui_action_add_refresh (DuiAction *, const char * name);

/* rerun the last query (and display it in a report).
 * this routine is used to refresh a window.
 */
void dui_action_rerun_last_query (DuiAction *act);


/* Add a chained action */
void dui_action_add_chain (DuiAction *act, const char * actionname);

void dui_action_do_realize (DuiAction *);
int dui_action_is_realized (DuiAction *);


#endif /* DUI_ACTION_H */

/* ========================== END OF FILE ============================ */
