
/* 
 * FILE:
 * dui-odbc.h
 *
 * FUNCTION:
 * Open up connection to the database. (Uses ODBC under the covers).
 *
 * HISTORY:
 * created by Linas Vepstas  March 2002
 */


#ifndef DUI_ODBC_H
#define DUI_ODBC_H


typedef struct DuiODBCConnection_s DuiODBCConnection;
typedef struct DuiODBCRecordSet_s  DuiODBCRecordSet;


DuiODBCConnection * dui_odbc_connection_new (const char * dbname, 
                                      const char * username);

void dui_odbc_connection_free (DuiODBCConnection *conn);

/* issue a query on this connection.  FYI -- the query is actually performed
 * asynchronously; the record set may not yet contain valid data when this 
 * routine returns. */
DuiODBCRecordSet * dui_odbc_connection_exec (DuiODBCConnection *, 
                const char * buff);

/* get a list of tables in this database */
DuiODBCRecordSet * dui_odbc_connection_tables (DuiODBCConnection *);
 
/* get a list of columns in the named table */
DuiODBCRecordSet * dui_odbc_connection_table_columns (DuiODBCConnection *,
                      const char * table_name);

/* release the record set when one is done with it */
void dui_odbc_recordset_release (DuiODBCRecordSet *);

/* Prep a row.  Basically, this gets the 'next' row out of the database.
 * Subsequent field fetches are for this row. Returns zero if there are 
 * no more rows.
 */
int dui_odbc_recordset_fetch_row (DuiODBCRecordSet *rs);

/* Get the field value by name.  This is a little different/easier than 
 * the usual trick of getting it by column number.
 */
const char * dui_odbc_recordset_get_value (DuiODBCRecordSet *, 
                const char * fieldname);


#endif /* DUI_ODBC_H */
 
