
/* 
 * FILE:
 * dui-initdb.h
 *
 * FUNCTION:
 * Open up connection to the database. 
 *
 * HISTORY:
 * created by Linas Vepstas  March 2002
 */


#ifndef DUI_INITDB_H
#define DUI_INITDB_H


typedef struct DuiDBConnection_s DuiDBConnection;
typedef struct DuiDBRecordSet_s  DuiDBRecordSet;


/* For now, the only supported provider is be "odbc" */
DuiDBConnection * dui_connection_new (const char * provider,
                                      const char * dbname, 
                                      const char * username);

void dui_connection_free (DuiDBConnection *conn);

/* issue a query on this connection.  FYI -- the query is actually performed
 * asynchronously; the record set may not yet contain valid data when this 
 * routine returns.  Valid data is not available until th (possibly blocking)
 * routine dui_recordset_fetch_row() is called. */
DuiDBRecordSet * dui_connection_exec (DuiDBConnection *, const char * buff);

/* return a list of tables on this connection. */
DuiDBRecordSet * dui_connection_tables (DuiDBConnection *);

/* get a list of columns in the named table */
DuiDBRecordSet * dui_connection_table_columns (DuiDBConnection *,
                      const char * table_name);


/* release the record set when one is done with it */
void dui_recordset_free (DuiDBRecordSet *);

/* prep a row.  Basically, this gets the 'next' row out of the database.
 * subsequent field fetches are for this row. Returns zero if there are 
 * no more rows.
 */
int dui_recordset_fetch_row (DuiDBRecordSet *rs);

/* Get the field value by name.  This is a little different/easier than 
 * the usual trick of getting it by column number.
 */
const char * dui_recordset_get_value (DuiDBRecordSet *, const char * fieldname);


#endif /* DUI_INITDB_H */
 
