/*****
*
* This file is part of the OMS program.
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by 
* the Free Software Foundation; either version 2, or (at your option)
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; see the file COPYING.  If not, write to
* the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*
*****/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>

#if HAVE_CONFIG_H
# include <config.h>
#endif
#include <oms/oms.h>
#include <oms/log.h>
#include <oms/buf.h>		// for SetFilter - CLEANUP
#include "config_store.h"


static int audio_plugin_load(void)
{
        gchar *audio_device, *audio_plugin;
        
        audio_plugin = cfg_get_defval_string ("output_audio_plugin", "sys");
        audio_device = cfg_get_defval_string ("output_audio_device", "/dev/dsp");
        
        return omsOpenOutputAudio (NULL, audio_plugin, audio_device);
}  


static int video_plugin_load(void)
{   
	gchar *video_device, *video_plugin;
    
	video_plugin = cfg_get_defval_string ("output_video_plugin", "x11");
	video_device = cfg_get_defval_string ("output_video_device", "/dev/null");
        
	return omsOpenOutputVideo (NULL, video_plugin, video_device);
}


int main (int argc, char *argv[])
{
	gchar *plugin_dir;
	int i;

	oms_init ();
	cfg_init ();

	plugin_dir = cfg_get_defval_string ("plugin_dir", PLUGIN_DIR);
	plugin_mgr_scandir (plugin_dir);

	audio_plugin_load ();
	video_plugin_load ();

	if (argc == 1) {
		gchar *str;	//FIXME: cut at ';'
		//str = cfg_get_defval_string ("devices", "dvd:/dev/dvd");
		str = strdup ("dvd:/dev/dvd");

		if (!omsOpenInput (str)) {
			omsSetFilter (BUF_SUBPIC, 1);
			omsPlay ();
			omsCloseInput ();
		}
		free (str);
		goto exit;
	}

	for (i=1; i<argc; i++) {
		char str[1005];

// FIXME: check if we already have an uri part included (e.g. dvd:)
		snprintf (str, 1005, "file:%s", argv[i]);

		if (!omsOpenInput (str)) {
			omsPlay ();
			omsCloseInput ();
		}
	}

exit:
	omsCloseOutput ();
	cfg_save ();

	oms_exit ();

	return 0;
}
