/*****
*
* This file is part of the OMS program.
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by 
* the Free Software Foundation; either version 2, or (at your option)
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; see the file COPYING.  If not, write to
* the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*
*****/

/*  Open Media System - oms
 * 
 *  configuration-management, -file i/o
 *
 * Copyright (C) 1999  Thomas Mirlacher, Guenter Bartsch
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __CFG_STORE_H__
#define __CFG_STORE_H__

#include <glib.h>

void cfg_set_val_string (const gchar *strKey_, gchar *strValue_) ;
gchar *cfg_get_val_string (const gchar *strKey_);
gchar *cfg_get_defval_string (const gchar *strKey_, gchar *strDefaultValue_);

int cfg_get_val_int (const gchar *strKey_, int nDefaultValue_) ;
void cfg_set_val_int (const gchar *strKey_, int nValue_);

// inititalize internal variables, read configuration
void cfg_init ();

// read configuration (again)
void cfg_read ();

// write configuration to file (~/.oms/config)
void cfg_save ();

#endif
