
/*
 * PROGRAM MAP TABLE ROUTINES
 *
 * Copyright (C) 1999  Thomas Mirlacher
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * The author may be reached as <dent@linuxvideo.org>
 *
 *------------------------------------------------------------
 *
 */


#include <stdio.h>
#include <stdlib.h>
#include <string.h>	//strdup

#include <bswap.h>

#include <dvb/pmt.h>
#include <dvb/dvb.h>
#include <dvb/descr.h>
#include "dvb.h"

#include "descr.h"
#include "decode.h"

// ISO/IEC 12818-1 P47

static int _parse_pmt_descr (uint8_t *buf, uint32_t len, void *dvb_pmt);

int parse_pmt (uint8_t *buf, dvb_pmt_t *dvb_pmt)
{
	struct pmt_struct* pmt = (struct pmt_struct*) buf;
	uint32_t sec_len;
	int info_len = 0,
		stream_len;
	uint8_t *ptr = buf;
	int tmp_info_len;

	if (pmt->table_id != TID_PMT) {
		fprintf (stderr, "PMT: wrong TID %x\n", pmt->table_id);
		return -1;
	}

	sec_len = bswap_16 (pmt->section_length);
	info_len = bswap_16 (pmt->program_info_length);

	if (sec_len < info_len + PMT_LEN)
		return -1;

	dvb_pmt->prog_nr = bswap_16 (pmt->program_number);
	dvb_pmt->version = pmt->version_number;
	dvb_pmt->pcr_pid = bswap_16 (pmt->PCR_PID);

	ptr += PMT_LEN;	

	tmp_info_len = info_len;

	while (tmp_info_len > 0) {
		_parse_pmt_descr (ptr, info_len, dvb_pmt);
		tmp_info_len -= get_descr_len (ptr) + DESCR_GEN_LEN;
		ptr += get_descr_len (ptr) + DESCR_GEN_LEN;
	}
	stream_len = (sec_len - info_len - PMT_LEN);
	
// delete previous entries
	if (dvb_pmt->stream) {
		struct dvb_pmt_stream_struct *ptr = dvb_pmt->stream;

		do {
			struct dvb_pmt_stream_struct *next = ptr->next;
			//if (ptr->info)
			//	free (ptr->info);
			free (ptr);
			ptr = next;
		} while (ptr);

		dvb_pmt->stream = NULL;
	}

	while (stream_len > 0) {
		struct dvb_pmt_stream_struct *stream;
		struct pmt_info_struct* info = (struct pmt_info_struct *) ptr;
		int descr_len;

// malloc struct entry and hook it into place
		stream = calloc (1, sizeof (struct dvb_pmt_stream_struct));

		if (!dvb_pmt->stream) 
			dvb_pmt->stream = stream;
		else {
			struct dvb_pmt_stream_struct *ptr = dvb_pmt->stream;

			while (ptr->next)
				ptr = ptr->next;

			ptr->next = stream;
		}

		stream->stream_type = info->stream_type;
		stream->pid = bswap_16 (info->elementary_PID);

		descr_len = bswap_16 (info->ES_info_length);

		ptr += PMT_info_LEN;

		stream_len -= PMT_info_LEN + get_descr_len (ptr);

		while (descr_len > 0) {
			_parse_pmt_descr (ptr, descr_len, stream);

			ptr += get_descr_len (ptr) + DESCR_GEN_LEN;
			descr_len -= get_descr_len (ptr) + DESCR_GEN_LEN;
		}
	}

	return 0;
}

static int _parse_pmt_descr (uint8_t *ptr, uint32_t len, void *dvb_pmt)
{
	switch (get_descr (ptr)) {
		case DESCR_MOSAIC:
		case DESCR_STREAM_ID:
		case DESCR_TELETEXT:
		case DESCR_SUBTITLING:
		case DESCR_SERVICE_MOVE:
		default:
			//fprintf (stderr, "PMT: unhandled descriptor (0x%0x) %s", get_descr(ptr), decode_descr(get_descr(ptr)));
			break;
	}

	return 0;
}
