/*****
*
* This file is part of the OMS program.
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by 
* the Free Software Foundation; either version 2, or (at your option)
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; see the file COPYING.  If not, write to
* the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*
*****/


/*
 *
 *
 * Copyleft (C) 1999  Thomas Mirlacher
 *
 * Do whatever you like with this piece of code ...
 * 
 * The author may be reached as <dent@linuxvideo.org>
 *
 *------------------------------------------------------------
 *
 */


#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <inttypes.h>
#include <sys/stat.h>
#include <fcntl.h>

#include <dvb/ts.h>
#include <dvb/dvb.h>

#include "tbl.h"
#include "sections.h"
#include "decode.h"

#define BUF_SIZE 188
uint8_t buf[BUF_SIZE];
uint8_t sec_buf[1024];

static void _print_all (dvb_pat_t *dvb_pat, dvb_sdt_t *dvb_sdt);

int main (int argc, char **argv)
{
	int fd_in;
	int len;
	uint8_t *ptr;
	dvb_pat_t *dvb_pat = calloc (1, sizeof (dvb_pat_t));
	dvb_sdt_t *dvb_sdt = calloc (1, sizeof (dvb_sdt_t));
	char *name = argv[1];
	//char name[] = "/home/project/dvb/dumps/1399_anthun.dat";

#if 1
// get SDT	
	fd_in = open (name, O_RDONLY);

	while ((len = read (fd_in, buf, BUF_SIZE))) {
		if ((ptr = filter_section (buf, sec_buf, PID_SDT))) {
			if (parse_sdt (ptr, dvb_sdt) >= 0) 
				break;
		}
	}

	filter_section (buf, NULL, 0x00);
	close (fd_in);
#endif
// get PAT
	fd_in = open (name, O_RDONLY);

	while ((len = read (fd_in, buf, BUF_SIZE))) {
		if ((ptr = filter_section (buf, sec_buf, PID_PAT))) {
			if (parse_pat (ptr, dvb_pat) >= 0)
				break;
		}
	}

	filter_section (buf, NULL, 0x00);
	close (fd_in);

// have pat
{	
	dvb_pat_prog_t *prog;
	prog = dvb_pat->prog;

	fd_in = open (name, O_RDONLY);

	while ((len = read (fd_in, buf, BUF_SIZE)) && prog) {
		if ((ptr = filter_section (buf, sec_buf, prog->pid))) {
			if (!prog->prog_nr) {	// NIT
				dvb_nit_t *dvb_nit = calloc (1, sizeof (dvb_nit_t));
				if (parse_nit (ptr, dvb_nit) >= 0) {
					if (prog->prog.nit)
						free (prog->prog.nit);
					prog->prog.nit = dvb_nit;
					prog = prog->next;
	filter_section (buf, NULL, 0x00);
				} else {
					free (dvb_nit);
				}
			} else {
				dvb_pmt_t *dvb_pmt = calloc (1, sizeof (dvb_pmt_t));

				if (parse_pmt (ptr, dvb_pmt) >= 0) {
					if (prog->prog.pmt)
						free (prog->prog.pmt);
					prog->prog.pmt = dvb_pmt;
					prog = prog->next;
	filter_section (buf, NULL, 0x00);
				} else {
					free (dvb_pmt);
				}
			}
		}
	}

	close (fd_in);
}
	_print_all (dvb_pat, dvb_sdt);

	return 0;
}

static void _print_all (dvb_pat_t *dvb_pat, dvb_sdt_t *dvb_sdt)
{
	dvb_pat_prog_t *prog;

	printf ("PAT:\n");
	printf ("TS_ID: 0x%x Version: 0x%x\n", dvb_pat->ts_id, dvb_pat->version);
#if 0
	if (dvb_sdt->ts_id == dvb_pat->ts_id) {
		printf ("\tts_id: 0x%x\n", dvb_sdt->ts_id);
		printf ("\torig_nw: 0x%x\n", dvb_sdt->orig_nw_id);
		if (dvb_sdt->service && dvb_sdt->service->descr) {
			if (dvb_sdt->service->descr->country_avail)	
				printf ("\tavailable in: %s\n", dvb_sdt->service->descr->country_avail);

			if (dvb_sdt->service->descr->service) {
				printf ("\ttype: %s\n", decode_service_type (dvb_sdt->service->descr->service->service_type));
				printf ("\tprovider: %s\n", dvb_sdt->service->descr->service->provider_name);
				printf ("\tservice: %s\n", dvb_sdt->service->descr->service->service_name);
			}
		}
	}
#endif
	prog = dvb_pat->prog;

	while (prog) {
		printf ("\tProg_Nr: 0x%x PID: 0x%x\n", prog->prog_nr, prog->pid);
		if (!prog->prog_nr) {	// NIT
			if (!prog->prog.nit) {
				printf ("\t\tNo details.\n");
			} else {

			printf ("\t\tts_id: 0x%x\n", prog->prog.nit->ts_id);
			printf ("\t\torig_nw_id: 0x%x\n", prog->prog.nit->orig_nw_id);
			printf ("\t\tname: %s\n", prog->prog.nit->name);
			printf ("\t\tfreq: %d\n", prog->prog.nit->freq);
			printf ("\t\torb: %f\n", prog->prog.nit->orbit);
			printf ("\t\twest_east: %c\n", prog->prog.nit->west_east ? 'E' : 'W');
			printf ("\t\trate: %d\n", prog->prog.nit->rate);
			printf ("\t\tfec: %s\n", decode_fec (prog->prog.nit->fec));
			}
// modulation, polarization
		} else { // PMT
			dvb_pmt_stream_t *stream;

			if (!prog->prog.pmt) {
				printf ("\t\tNo details.\n");
			} else {

			stream = prog->prog.pmt->stream;

			//printf ("\t\tprog_nr: 0x%x\n", prog->prog.pmt->prog_nr);
// SDT
			if (dvb_sdt && dvb_sdt->service) {
				dvb_sdt_service_t *service = dvb_sdt->service;

				while (service) {
					if (prog->prog.pmt->prog_nr == service->service_id) {
						if (service->descr && service->descr->service) {
							printf ("\t\tprovider: %s\n", service->descr->service->provider_name);
							printf ("\t\tservice: %s\n", service->descr->service->service_name);
						}
					}		
					service = service->next;
				}
			}

			printf ("\t\tversion: 0x%x\n", prog->prog.pmt->version);
			printf ("\t\tpcr PID: 0x%x\n", prog->prog.pmt->pcr_pid);

			while (stream) {
				//printf ("\t\t\tinfo: %s\n", stream->info);
				printf ("\t\t\tpid: 0x%x\n", stream->pid);
				printf ("\t\t\ttype: (0x%x) %s\n", stream->stream_type, decode_stream_type (stream->stream_type));

				stream = stream->next;
			}
			}
		}

		prog = prog->next;
	}
}
