//PLUGIN_INFO(INFO_NAME, "Null audio driver output");
//PLUGIN_INFO(INFO_AUTHOR, "Thomas Mirlacher <dent@linuxvideo.org>");

/*
 *
 *  audio_out_null.c
 *    
 *	Copyright (C) Thomas Mirlacher 2000-2001
 *
 *  This file is part of ac3dec, a free Dolby AC-3 stream decoder.
 *	
 *  ac3dec is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  ac3dec is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 *
 */

#include <oms/oms.h>
#include <oms/plugin/codec.h>
#include <oms/plugin/output_audio.h>

static int _audio_null_open (void *plugin, void *name);
static int _audio_null_close (void *plugin);
static int _audio_null_setup (plugin_output_audio_attr_t * attr);
static int _audio_null_write (const void *buf, size_t num_bytes);
static int _audio_null_check (void);

static int _codec_null_open (void *this, void *output_audio);
static int _codec_null_close (void *this);
static int _codec_null_read (void *this, buf_t * buf,

			     buf_entry_t * buf_entry);

static plugin_output_audio_t audio_null = {
	open:_audio_null_open,
	close:_audio_null_close,
	setup:_audio_null_setup,
	write:_audio_null_write,
	check:_audio_null_check,
	config:NULL,
};

static plugin_codec_t codec_null = {
	open:_codec_null_open,
	close:_codec_null_close,
	read:_codec_null_read,
	config:NULL,
};

static int _audio_null_open (void *plugin, void *name)
{
	//do nothing
	return 0;
}

static int _audio_null_close (void *plugin)
{
	return 0;
}

static int _audio_null_setup (plugin_output_audio_attr_t * attr)
{
	//do nothing
	return 0;
}

static int _audio_null_write (const void *buf, size_t num_bytes)
{
	//do nothing
	return 0;
}

static int _audio_null_check (void)
{
	//do nothing
	return 0;
}

static int _codec_null_open (void *this, void *output_audio)
{
	return 0;
}

static int _codec_null_close (void *this)
{
	return 0;
}

static int _codec_null_read (void *this, buf_t * buf,
			     buf_entry_t * buf_entry)
{
	return 0;
}

int PLUGIN_INIT (audio_null) (char *whoami) {
	pluginRegister (whoami,
			PLUGIN_ID_OUTPUT_AUDIO,
			NULL, "null", NULL, &audio_null);

	pluginRegister (whoami,
			PLUGIN_ID_CODEC_AUDIO,
			"pcm;ac3;mpg1;mpg2;mpeg", NULL, NULL, &codec_null);

	return 0;
}

/**
 * Cleanup Plugin.
 **/

void PLUGIN_EXIT (audio_null) (void) {
}
