/*****
*
* This file is part of the OMS program.
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by 
* the Free Software Foundation; either version 2, or (at your option)
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; see the file COPYING.  If not, write to
* the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*
*****/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dlfcn.h>

#include <oms/oms.h>
#include <oms/plugin/input.h>
#include <oms/plugin/decaps.h>
#include <oms/plugin/nav.h>
#include <oms/plugin/codec.h>

#include "../input/input_vcd.h"

static int _vcd_open (void *plugin, void *path);
static int _vcd_close (void *plugin);
static int _vcd_play (int title, int chapter, int parts2play);
static int _vcd_RegisterCb (uint id, oms_callback_t cb, void *data);
static int _vcd_UnregisterCb (uint id);
static nav_tree_t *_vcd_get_info (uint id);

static struct {
} vcd_priv;

static plugin_nav_t vcd_nav = {
	priv:&vcd_priv,
	open:_vcd_open,
	close:_vcd_close,
	play:_vcd_play,
	get_info:_vcd_get_info,
	register_cb:_vcd_RegisterCb,
	unregister_cb:_vcd_UnregisterCb,
	config:NULL,
};

static int _vcd_open (void *plugin, void *path)
{
	plugin_input_t *plugin_input;
	plugin_decaps_t *plugin_decaps;

	if (!(plugin_input = pluginLoad (PLUGIN_ID_INPUT, "vcd ", NULL))) {
		LOG (LOG_ERROR, "failed to open input plugin");
		return -1;
	}
	plugin_input->open (plugin_input, path);

	if (!(plugin_decaps = pluginLoad (PLUGIN_ID_DECAPS, "ps  ", NULL))) {
		LOG (LOG_ERROR, "failed to open decaps plugin");
		return -1;
	}
	plugin_decaps->blocksize = plugin_input->blocksize;
	plugin_decaps->read = plugin_input->read;
	plugin_decaps->write = oms_buf_validate;
	plugin_decaps->open (plugin_decaps, NULL);

// AUDIO
	if (!pluginLoad (PLUGIN_ID_CODEC_AUDIO, "mpg1", NULL)) {
		LOG (LOG_ERROR,
		     "failed to open mpg123 audio codec plugin");
		return -1;
	}

	{
		plugin_codec_t *plugin_codec_audio;

		plugin_codec_audio =
		    plugin_get_active_ops (PLUGIN_ID_CODEC_AUDIO);
		plugin_codec_audio->open (plugin_codec_audio, NULL);
		plugin_codec_audio->output =
		    plugin_get_active_ops (PLUGIN_ID_OUTPUT_AUDIO);
	}

// VIDEO
	if (!pluginLoad (PLUGIN_ID_CODEC_VIDEO, "mpg2", NULL)) {
		LOG (LOG_ERROR, "failed to open video codec plugin");
		return -1;
	}

	{
		plugin_codec_t *plugin_codec_video;

		plugin_codec_video =
		    plugin_get_active_ops (PLUGIN_ID_CODEC_VIDEO);
		plugin_codec_video->open (plugin_codec_video, NULL);
		plugin_codec_video->output =
		    plugin_get_active_ops (PLUGIN_ID_OUTPUT_VIDEO);
	}

	return 0;
}

static int _vcd_close (void *plugin)
{
//      return PLUGIN_OPS_INPUT(((plugin_nav_t *)plugin)->plugin_list)->close (((plugin_nav_t *)plugin)->plugin_list->ops[PLUGIN_ID_INPUT]);
	return 0;
}

static int _vcd_play (int title, int chapter, int parts2play)
{
	plugin_input_t *plugin_input =

	    plugin_get_active_ops (PLUGIN_ID_INPUT);

//      plugin_codec_attr_audio_t attr_audio = {1, 0, 0, 0, -1};
//      plugin_codec_attr_video_t attr_video = {1, 0, 1, -1, 2};

	plugin_input->seek (plugin_input, chapter);

//VCD MPEG,50Hz, PAL
//      PLUGIN_OPS_CODEC_AUDIO(vcd_priv.nav, set_attributes, BUF_VIDEO, &attr_video);
//MPEG,16bit,44.1kHz
//      PLUGIN_OPS_CODEC_AUDIO(vcd_priv.nav, set_attributes, BUF_AUDIO, &attr_audio);

	return 0;
}

static int _vcd_RegisterCb (uint id, oms_callback_t cb, void *data)
{
	return 0;
}

static int _vcd_UnregisterCb (uint id)
{
	return 0;
}

#define TRACK_NAME_LEN (6 + 3 + 1)

static nav_tree_t *_vcd_get_info (uint id)
{
	plugin_input_t *plugin_input =

	    plugin_get_active_ops (PLUGIN_ID_INPUT);
	nav_tree_t *tree = 0;
	int i;

	switch (id) {
	case OMS_INFO_PROGRAM:{
			int tracks;

			tracks =
			    ((vcd_priv_t
			      *) (plugin_input->priv))->total_tracks;
			tree = malloc (sizeof (nav_tree_t));

			tree->num = 1;
			tree->title =
			    malloc (sizeof (nav_subtree_t) * tree->num);

			{
				nav_subtree_t *sub_tree = tree->title;
				char *name;

				sub_tree->sub = (nav_tree_data_t *)
				    malloc (sizeof (nav_tree_data_t) *
					    tracks);

				sub_tree->num = tracks;
				sub_tree->name = "VCD";
				for (i = 0; i < tracks; i++) {
					nav_tree_data_t *data =
					    sub_tree->sub + i;

					name = (char *)
					    malloc (TRACK_NAME_LEN);
					snprintf (name, TRACK_NAME_LEN,
						  "Track %d", i);
					data->name = name;
				}
			}
			break;
		}
	default:
		LOG (LOG_DEBUG, "unhandled OMS_INFO %s", "tjo");
	}

	return tree;
}

int plugin_init (char *whoami)
{
	pluginRegister (whoami, PLUGIN_ID_NAV, "vcd", NULL, NULL,
			&vcd_nav);

	return 0;
}
void plugin_exit (void)
{
}
