/*****
*
* This file is part of the OMS program.
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by 
* the Free Software Foundation; either version 2, or (at your option)
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; see the file COPYING.  If not, write to
* the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*
*****/

#ifndef __INPUT_VCD_H__
#define __INPUT_VCD_H__

#if defined (__linux__)
#include <linux/cdrom.h>
#elif defined (__NetBSD__) || defined(__OpenBSD__)
#include <sys/dvdio.h>
#elif defined (__sun__)
#include <sys/cdio.h>
#define CD_FRAMESIZE_RAW 2352
#define CD_SECS 60
#define CD_FRAMES 75
#define CD_MSF_OFFSET 150
#else
#error "You need add support for CD-ROM / VCD support"
#endif

typedef struct {
	struct cdrom_tochdr tochdr;
	struct cdrom_tocentry tocent[100];
	int fd;
	struct {
		u_char minute;
		u_char second;
		u_char frame;
	} time; //cdrom_msf0

	int total_tracks;
	int current_track;
	int counter;

	struct {
		void (*chapter) (void *data, int chapter);
		void *chapter_data;
	} callb;        // Callbacks

} vcd_priv_t;

#endif
