
/*
 *
 * Copyright (C) 1999-2000  Thomas Mirlacher
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * The author may be reached as <dent@linuxvideo.org>
 *
 *------------------------------------------------------------
 *
 */


#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <string.h>
#include <errno.h>

#include <oms/log.h>
#include <oms/plugin/input.h>

#include "input_file.h"

static int file_open	(void *self, void *name);
static int file_close	(void *self);
static ssize_t file_read(void *self, void *buf, size_t count);
static int file_seek	(void *self, off_t pos);

static file_priv_t priv = {
	fd:	-1,
	callb:	{
		chapter:	NULL,
		chapter_data:	NULL
	}
};

static plugin_input_t input = {
	priv:		&priv,
	open:		file_open,
	close:		file_close,
	read:		file_read,
	seek:		file_seek,
	blocksize:	2048,
        config:         NULL,
};


static int file_open (void *self, void *name)
{
	if ((priv.fd = open (name, O_RDONLY)) < 0) {
		LOG (LOG_ERROR, "open (%s)", strerror (errno));
		return -1;
	}

	return 0;
}


static int file_close (void *self)
{
	if (priv.fd < 0)
		return -1;

	return close (priv.fd);
}


static ssize_t file_read (void *self, void *buf, size_t count)
{
	ssize_t ret = read (priv.fd, buf, count);

	if (!ret && priv.callb.chapter)
		priv.callb.chapter (priv.callb.chapter_data, 1);

	return ret;
}


static int file_seek (void *self, off_t pos)
{
	lseek (priv.fd, pos, SEEK_SET); 
	return 0;
}


int PLUGIN_INIT (input_file) (char *whoami)
{
	pluginRegister (whoami,
		PLUGIN_ID_INPUT,
		"file",
		NULL,
		NULL,
		&input);

	return 0;
}


void PLUGIN_EXIT (input_file) (void)
{
}
