/*****
*
* This file is part of the OMS program.
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by 
* the Free Software Foundation; either version 2, or (at your option)
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; see the file COPYING.  If not, write to
* the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*
*****/

// @reference:  http://www.jmcgowan.com/avi.html

#ifndef __RIFF_H__
#define __RIFF_H__

// 'vids'       Video Stream
#define RIFF_VIDS	mmioFOURCC ('v','i','d','s')
// 'auds'       Audio Stream
#define RIFF_AUDS	mmioFOURCC ('a','u','d','s')
#define RIFF_RIFF	mmioFOURCC ('R','I','F','F')
#define RIFF_LIST	mmioFOURCC ('L','I','S','T')
// 'avih'       AVI Header
#define RIFF_AVIH	mmioFOURCC ('a','v','i','h')
// 'strh'       Stream Header
#define RIFF_STRH	mmioFOURCC ('a','v','i','h')
// 'strf'       Stream Format
#define RIFF_STRF	mmioFOURCC ('s','t','r','f')
// 'JUNK'
#define RIFF_JUNK	mmioFOURCC ('J','U','N','K')

// generic header
typedef struct avi_hdr_struct {
	uint32_t descr_type;	// LIST, RIFF
	uint32_t len;
	//uint32_t      descr;
} avi_hdr_t;

// AVI header
typedef struct avi_avih_struct {
	uint32_t us_frame;
	uint32_t max_bps;
	uint32_t pad_gran;
	uint32_t flags;
	uint32_t tot_frames;
	uint32_t init_frames;
	uint32_t streams;
	uint32_t sug_bsize;
	uint32_t width;
	uint32_t height;
	uint32_t scale;
	uint32_t rate;
	uint32_t start;
	uint32_t length;
} avi_avih_t;

// Video Stream Stream Format
typedef struct avi_vids_strf_struct {
	uint32_t size;
	uint32_t width;
	uint32_t height;
	uint16_t planes;
	uint16_t bit_depth;
	uint32_t compression;
	uint32_t image_size;
	uint32_t xpels_meter;
	uint32_t ypels_meter;
	uint32_t num_colors;
	uint32_t imp_colors;
} avi_vids_strf_t;

// Audio Stream Stream Format
typedef struct avi_auds_strf_struct {
	uint16_t wFormatTag;
	uint16_t channels;
	uint32_t rate;
	uint32_t avg_Bps;
	uint16_t align;
	uint16_t bp_sample;
} avi_auds_strf_t;

// Stream Header
typedef struct avi_strh_struct {
	uint32_t fourcc_type;
	uint32_t fourcc_handler;
	uint32_t flags;
	uint32_t priority;
	uint32_t init_frames;
	uint32_t scale;
	uint32_t rate;
	uint32_t start;
	uint32_t len;
	uint32_t sug_bsize;
	uint32_t quality;
	uint32_t samp_size;
} avi_strh_t;

#endif
