/*****
*
* This file is part of the OMS program.
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by 
* the Free Software Foundation; either version 2, or (at your option)
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; see the file COPYING.  If not, write to
* the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*
*****/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <inttypes.h>
#include <sys/stat.h>

#include <oms/oms.h>
#include <oms/log.h>
#include <oms/plugin/codec.h>
#include <oms/plugin/output_video.h>	// for clut_t
#include "spu.h"

static struct spu_img_struct spu;

static int _spudec_open	(void *plugin, void *foo);
static int _spudec_close(void *plugin);
static int _spudec_read	(void *plugin, buf_t *buf, buf_entry_t *buf_entry);
static int _spudec_ctrl	(void *plugin, uint ctrl_id, ...);

static void _spudec_config(void);

static plugin_codec_t codec_spudec = {
	open:	_spudec_open,
	close:	_spudec_close,
	read:	_spudec_read,
	ctrl:	_spudec_ctrl,
        config: _spudec_config,
};


/*
 * Config stuff.
 */

void _spudec_config (void) 
{
        config_t *cfg;
        const char *ptr;
        double color[3];
        
        cfg = omsConfigOpen();

        ptr = config_get(cfg, NULL, "subtitle_color");
        sscanf(ptr, "%lf,%lf,%lf", &color[0], &color[1], &color[2]);
        
        printf ("%s: red=%f, green=%f, blue=%f\n", __FUNCTION__, color[0], color[1], color[2]);        
}

/************************************************/

static int _spudec_open (void *plugin, void *foo)
{
	spuInit ();
        return 0;
}


static int _spudec_close (void *plugin)
{
        //spudec_close (((plugin_codec_t *) plugin)->output);

        return 0;
}


static int _spudec_read (void *plugin, buf_t *buf, buf_entry_t *buf_entry)
{
	if (!spuParseHdr (&spu, buf_entry->data, buf_entry->data_len)) {
		spuParseData (&spu);

		if (((plugin_codec_t *) plugin)->output) {
			plugin_output_video_t *output;
			output = (plugin_output_video_t *) ((plugin_codec_t *) plugin)->output;
			if (output) {
				if (output->overlay) {
					output->overlay ((overlay_buf_t *) &spu, 0);
				}
			}
		}
	}

	//(spu.time_execute);

	return 0;
}


static int _spudec_ctrl (void *plugin, uint ctrl_id, ...)
{
	va_list arg_list;

	va_start (arg_list, ctrl_id);
	switch (ctrl_id) {
		case CTRL_SPU_SET_CLUT: {
			spu.clut = (clut_t *) va_arg (arg_list, clut_t *);
			break;
		}
		default:
			va_end (arg_list);
			return -1;
	}

	va_end (arg_list);
	return 0;
}


/*****************************************/


int plugin_init (char *whoami)
{
        pluginRegister (whoami,
                PLUGIN_ID_CODEC_SPU,
                "spu",
                NULL,
                "<colorpicker name=\"Subtitle color selection\" variable=\"subtitle_color\"/>",
                &codec_spudec);

        return 0;
}


void plugin_exit (void)
{
}
