/*****
*
* This file is part of the OMS program.
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by 
* the Free Software Foundation; either version 2, or (at your option)
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; see the file COPYING.  If not, write to
* the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*
*****/

#ifndef __MISC_H__
#define __MISC_H__

#include <stdio.h>
#include <stdarg.h>
#include <bswap.h>
#include "ifo.h"

#define OFFSET_IFO		0x0000
#define OFFSET_VTS		0x0000
#define OFFSET_LEN		0x00C0
#define IFO_OFFSET_TAT		0x00C0
#define OFFSET_VTSI_MAT		0x0080
#define IFO_OFFSET_VIDEO	0x0100
#define IFO_OFFSET_AUDIO	0x0200
#define IFO_OFFSET_SUBPIC	0x0250
#define IFO_OFFSET_FIRST_PGC	0x0400


uint32_t get4bytes (const uint8_t *buf);
uint16_t get2bytes (const uint8_t *buf);

int ifoReadTBL (ifo_t *ifo, off_t offset, uint8_t tbl_id);

#ifndef __LOG
#define __LOG
#define LOG_ERROR               0
#define LOG_WARNING             1
#define LOG_INFO                6
#define LOG_DEBUG               7

#ifdef DEBUG
#define LOG(lvl,args...)\
do {\
fprintf (stderr, "%d\t%s:%s#%d\t", lvl, __FILE__, __FUNCTION__, __LINE__);\
fprintf (stderr, args);\
fprintf (stderr, "\n");\
} while (0)
#else
#define LOG(lvl,args...)\
if (lvl != LOG_DEBUG) {\
fprintf (stderr, "%d\t%s:%s#%d\t", lvl, __FILE__, __FUNCTION__, __LINE__);\
fprintf (stderr, args);\
fprintf (stderr, "\n");\
}
#endif
#endif

#endif
