/*****
*
* This file is part of the OMS program.
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by 
* the Free Software Foundation; either version 2, or (at your option)
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; see the file COPYING.  If not, write to
* the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*
*****/

#ifndef __DVDDB_H__
#define __DVDDB_H__

#include <stdio.h>

int dvddbNetConnect (void);
int dvddbNetDisconnect (int sock);
int dvddbNetPut (int sock, int fd, char *id);
int dvddbNetGet (int sock, char *id);

FILE *dvddbOpen (char *id);
int dvddbClose (FILE *file);
char *dvddbRead (FILE *file);

int dvddbGetID (char *device, char *id);


#ifndef LOG

#define LOG_ERROR               0
#define LOG_WARNING             1
#define LOG_INFO                6
#define LOG_DEBUG               7

#ifdef DEBUG
#define LOG(lvl,args...)                                   \
                if (lvl != LOG_DEBUG)                                 \
                do {                                                    \
                        fprintf (stderr, "%d\t%s:%s#%d\t", lvl, __FILE__, __FUNCTION__, __LINE__);\
                        fprintf (stderr, args);                   \
                        fprintf (stderr, "\n");                         \
                } while (0)
#else
#define LOG(lvl,args...)                                   \
        do {                                                            \
                fprintf (stderr, "%d\t%s:%s#%d\t", lvl, __FILE__, __FUNCTION__, __LINE__);\
                fprintf (stderr, args);                           \
                fprintf (stderr, "\n");                                 \
        } while (0)
#endif /* DEBUG */
#endif /* LOG */
#endif /* __DVDDB_H__ */
