# Configure paths for liboms
# Sam Lantinga 9/21/99
# stolen from Manish Singh
# stolen back from Frank Belew
# stolen from Manish Singh
# Shamelessly stolen from Owen Taylor

dnl AM_PATH_OMS([MINIMUM-VERSION, [ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]]])
dnl Test for oms, and define OMS_CFLAGS and OMS_LIBS and OMS_CONFIG
dnl
AC_DEFUN(AM_PATH_OMS,
[dnl 
dnl Get the cflags and libraries from the oms-config script
dnl
AC_ARG_WITH(oms-prefix,[  --with-oms-prefix=PFX   Prefix where OMS is installed (optional)],
            oms_prefix="$withval", oms_prefix="")
AC_ARG_WITH(oms-exec-prefix,[  --with-oms-exec-prefix=PFX Exec prefix where OMS is installed (optional)],
            oms_exec_prefix="$withval", oms_exec_prefix="")
AC_ARG_ENABLE(omstest, [  --disable-omstest      Do not try to compile and run a test OMS program],
		    , enable_omstest=yes)

  if test x$oms_exec_prefix != x ; then
     oms_args="$oms_args --exec-prefix=$oms_exec_prefix"
     if test x${OMS_CONFIG+set} != xset ; then
        OMS_CONFIG=$oms_exec_prefix/bin/oms-config
     fi
  fi
  if test x$oms_prefix != x ; then
     oms_args="$oms_args --prefix=$oms_prefix"
     if test x${OMS_CONFIG+set} != xset ; then
        OMS_CONFIG=$oms_prefix/bin/oms-config
     fi
  fi

  AC_PATH_PROG(OMS_CONFIG, oms-config, no)
  min_oms_version=ifelse([$1], ,0.11.0,$1)
  AC_MSG_CHECKING(for OMS - version >= $min_oms_version)
  no_oms=""
  if test "$OMS_CONFIG" = "no" ; then
    no_oms=yes
  else
    OMS_CFLAGS=`$OMS_CONFIG $omsconf_args --cflags`
    OMS_LIBS=`$OMS_CONFIG $omsconf_args --libs`

    oms_major_version=`$OMS_CONFIG $oms_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`
    oms_minor_version=`$OMS_CONFIG $oms_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`
    oms_micro_version=`$OMS_CONFIG $oms_config_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`
    if test "x$enable_omstest" = "xyes" ; then
      ac_save_CFLAGS="$CFLAGS"
      ac_save_LIBS="$LIBS"
      CFLAGS="$CFLAGS $OMS_CFLAGS"
      LIBS="$LIBS $OMS_LIBS"
dnl
dnl Now check if the installed oms is sufficiently new. (Also sanity
dnl checks the results of oms-config to some extent
dnl
      rm -f conf.omstest
      AC_TRY_RUN([
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "oms/oms.h"

char*
my_strdup (char *str)
{
  char *new_str;
  
  if (str)
    {
      new_str = (char *)malloc ((strlen (str) + 1) * sizeof(char));
      strcpy (new_str, str);
    }
  else
    new_str = NULL;
  
  return new_str;
}

int main (int argc, char *argv[])
{
  int major, minor, micro;
  char *tmp_version;

  /* This hangs on some systems (?)
  system ("touch conf.omstest");
  */
  { FILE *fp = fopen("conf.omstest", "a"); if ( fp ) fclose(fp); }

  /* HP/UX 9 (%@#!) writes to sscanf strings */
  tmp_version = my_strdup("$min_oms_version");
  if (sscanf(tmp_version, "%d.%d.%d", &major, &minor, &micro) != 3) {
     printf("%s, bad version string\n", "$min_oms_version");
     exit(1);
   }

   if (($oms_major_version > major) ||
      (($oms_major_version == major) && ($oms_minor_version > minor)) ||
      (($oms_major_version == major) && ($oms_minor_version == minor) && ($oms_micro_version >= micro)))
    {
      return 0;
    }
  else
    {
      printf("\n*** 'oms-config --version' returned %d.%d.%d, but the minimum version\n", $oms_major_version, $oms_minor_version, $oms_micro_version);
      printf("*** of OMS required is %d.%d.%d. If oms-config is correct, then it is\n", major, minor, micro);
      printf("*** best to upgrade to the required version.\n");
      printf("*** If oms-config was wrong, set the environment variable OMS_CONFIG\n");
      printf("*** to point to the correct copy of oms-config, and remove the file\n");
      printf("*** config.cache before re-running configure\n");
      return 1;
    }
}

],, no_oms=yes,[echo $ac_n "cross compiling; assumed OK... $ac_c"])
       CFLAGS="$ac_save_CFLAGS"
       LIBS="$ac_save_LIBS"
     fi
  fi
  if test "x$no_oms" = x ; then
     AC_MSG_RESULT(yes)
     ifelse([$2], , :, [$2])     
  else
     AC_MSG_RESULT(no)
     if test "$OMS_CONFIG" = "no" ; then
       echo "*** The oms-config script installed by oms could not be found"
       echo "*** If oms was installed in PREFIX, make sure PREFIX/bin is in"
       echo "*** your path, or set the OMS_CONFIG environment variable to the"
       echo "*** full path to oms-config."
     else
       if test -f conf.omstest ; then
        :
       else
          echo "*** Could not run OMS test program, checking why..."
          CFLAGS="$CFLAGS $OMS_CFLAGS"
          LIBS="$LIBS $OMS_LIBS"
          AC_TRY_LINK([
#include <stdio.h>
#include "video_out.h"
],      [ return 0; ],
        [ echo "*** The test program compiled, but did not run. This usually means"
          echo "*** that the run-time linker is not finding oms or finding the wrong"
          echo "*** version of oms. If it is not finding oms, you'll need to set your"
          echo "*** LD_LIBRARY_PATH environment variable, or edit /etc/ld.so.conf to point"
          echo "*** to the installed location  Also, make sure you have run ldconfig if that"
          echo "*** is required on your system"
	  echo "***"
          echo "*** If you have an old version installed, it is best to remove it, although"
          echo "*** you may also be able to get things to work by modifying LD_LIBRARY_PATH"],
        [ echo "*** The test program failed to compile or link. See the file config.log for the"
          echo "*** exact error that occured. This usually means oms was incorrectly installed"
          echo "*** or that you have moved oms since it was installed. In the latter case, you"
          echo "*** may want to edit the oms-config script: $OMS_CONFIG" ])
          CFLAGS="$ac_save_CFLAGS"
          LIBS="$ac_save_LIBS"
       fi
     fi
     OMS_CFLAGS=""
     OMS_LIBS=""
     ifelse([$3], , :, [$3])
  fi
  AC_SUBST(OMS_CFLAGS)
  AC_SUBST(OMS_LIBS)
  AC_SUBST(OMS_CONFIG)
  rm -f conf.omstest
])
