
/*
 *
 * Copyright (C) 1999-2000  Thomas Mirlacher
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * The author may be reached as <dent@linuxvideo.org>
 *
 *------------------------------------------------------------
 *
 */

#ifndef __OUTPUT_VIDEO_H__
#define __OUTPUT_VIDEO_H__

#include <oms/plugin/generic.h>

#define IMG_ALLOC(h,w,f)						\
	frame_t *frame;							\
									\
	if (!(frame = malloc (sizeof (frame_t))))			\
		return NULL;						\
									\
	/* we only know how to do 4:2:0 planar yuv right now. */	\
	if (!(frame->private = malloc (width * height * 3 / 2))) {	\
		free(frame);						\
		return NULL;						\
	}								\
									\
	frame->base[0] = frame->private;				\
	frame->base[1] = frame->base[0] + width * height;		\
	frame->base[2] = frame->base[0] + width * height * 5 / 4;	\
									\
	return frame

#define IMG_FREE(frame)							\
	free (frame->private);						\
	free (frame)

// DENT: delete this -> cause this renders the possibility void to
//      have NULL pointers

#define LIBVIDEO_EXTERN(x,name) plugin_output_video_t video_out##x = { \
        priv:                   &(x ## _priv),\
        open:                   x ## _open,\
        close:                  x ## _close,\
        setup:                  x ## _setup,\
        draw_frame:             x ## _draw_frame,\
        draw_slice:             x ## _draw_slice,\
        flip_page:              x ## _flip_page,\
        overlay:                x ## _overlay,\
        allocate_image_buffer:  x ## _allocate_image_buffer,\
        free_image_buffer:      x ## _free_image_buffer\
}

#ifndef CLUT_T
#define CLUT_T
typedef struct {		// CLUT == Color LookUp Table
	uint8_t:8;
	uint8_t y:8;
	uint8_t cr:8;
	uint8_t cb:8;
} __attribute__ ((packed)) clut_t;
#endif

typedef struct overlay_buf_struct {
	u_char *data;		// 3-0: color index
	u_int x;		// x start of subpicture area
	u_int y;		// y start of subpicture area
	int width;		// width of subpicture area
	int height;		// height of subpicture area

	u_char clut_index[4];	// color lookup table
	u_char trans[4];	// mixer key table

	u_int time_execute;	// time in ms

	clut_t *clut;		// YUV-CLUT
} overlay_buf_t;

typedef struct frame_s {
	uint8_t *base[3];
	void *private;
} frame_t;

typedef struct plugin_output_video_attr_struct {
	uint32_t width;
	uint32_t height;
	uint32_t fullscreen;
	char *title;
} plugin_output_video_attr_t;

typedef struct plugin_output_video_struct {
	PLUGIN_GENERIC;

// setup can be called multiple times - opposite to open and close
//      calls which just are allowed to called once
	int (*setup) (plugin_output_video_attr_t * attr);

// request free buffer
	frame_t *(*buf_req) (size_t size);

// release buffer
	int (*buf_rel) (frame_t * img_buf);

// the buffer is ready for displaying
	int (*buf_output) (frame_t * img_buf);

// put an overlay in the queue
// id ... requested id (if the same already exists, replace it.)
// if id==0 assign a new id
// return assigned id
// NEEDED FOR SPUDEC .... SO TAKE CARE IF CHANGING !!!
	int (*overlay) (overlay_buf_t * overlay_buf, int id);

// <old>
	int (*draw_frame) (frame_t * frame);
	int (*draw_slice) (uint8_t * src[], int slice_num);
	void (*flip_page) (void);
	frame_t *(*allocate_image_buffer) (int width, int height,
					   uint32_t format);
	void (*free_image_buffer) (frame_t * image);
// </old>

// DENT: clean up ...
	char *name;
} plugin_output_video_t;

// DENT: just for now ... clean this up
#define vo_output_video_t plugin_output_video_t
#define vo_output_video_attr_t plugin_output_video_attr_t

#endif
