
/*
 *
 * Copyright (C) 1999  Thomas Mirlacher
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * The author may be reached as <dent@linuxvideo.org>
 *
 *------------------------------------------------------------
 *
 */

#ifndef __INPUT_H__
#define __INPUT_H__

#include <oms/plugin/generic.h>
#include <oms/buf.h>

#define CTRL_INPUT_TRAYOPEN	0x01
#define CTRL_INPUT_TRAYCLOSE	0x02

/**
 * input struct
 **/

typedef struct {
	PLUGIN_GENERIC;

/**
 * read - data-block from input media
 * @buf: pointer to actual buffer
 * @buf_entry: buffer entry
 *
 * read is a function ... blah blah
 **/
	ssize_t (*read) (void *self, void *buf, size_t count);

/**
 * seek - reposition read offset in input stream
 * @pos: offset to seek to
 * 
 * seek does ...
 **/
	int (*seek) (void *this, off_t pos);

// blocksize
	uint blocksize;
} plugin_input_t;
#endif
