
/*
 *
 * Copyright (C) 1999  Thomas Mirlacher
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * The author may be reached as <dent@linuxvideo.org>
 *
 *------------------------------------------------------------
 *
 */

#ifndef __DECAPS_H__
#define __DECAPS_H__

#include <oms/plugin/generic.h>
#include <oms/buf.h>

#define FILTER_AUDIO	0x01
#define FILTER_VIDEO	0x02
#define FILTER_SUBPIC	0x03
#define FILTER_PCR	0x04

#define CTRL_DECAPS_SETFILTER   0x01

typedef struct {
	char *file_ext;		// file extensions (ps;vob)
	uint len;		// length of file-magic (in bytes)
	u_char *magic;		// the magic itself
} plugin_decaps_magic_t;

typedef struct plugin_decaps_struct {
	PLUGIN_GENERIC;

// decapsulation itself
	int (*decaps) (buf_t * buf);
// read
	 ssize_t (*read) (void *self, void *buf, size_t count);
// put data-block into buffer (FILLED BY THE MANAGER)
	int (*write) (buf_t * buf, buf_entry_t * buf_entry);

// autodetection
	plugin_decaps_magic_t *magic;
// blocksize (FILLED BY THE MANAGER)
	uint blocksize;
} plugin_decaps_t;

#endif
