
/*
 *
 * Copyright (C) 2000  Thomas Mirlacher
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * The author may be reached as dent@cosy.sbg.ac.at, or
 * Thomas Mirlacher, Jakob-Haringerstr. 2, A-5020 Salzburg,
 * Austria
 *
 *------------------------------------------------------------
 *
 */

#ifndef __CODEC_H__
#define __CODEC_H__

#include <oms/plugin/generic.h>
#include <oms/buf.h>

typedef struct plugin_codec_struct {
	PLUGIN_GENERIC;
// read codec
	int (*read) (void *this, buf_t * buf, buf_entry_t * buf_entry);
// set operational status (PLAY, PAUSE, STOP)
	int (*set_status) (void *this, uint stats);
// set attributes (audio, video, spu)
	int (*set_attributes) (void *this, uint id, void *attr);
// output
	void *output;
} plugin_codec_t;

#define CTRL_RESET		0x00
#define CTRL_VIDEO_SET_STREAM	0x01
#define CTRL_VIDEO_INITIALIZED	0x02
#define CTRL_VIDEO_DROP_FRAME	0x03
#define CTRL_AUDIO_SET_STREAM	0x11
#define CTRL_AUDIO_INITIALIZED	0x12
#define CTRL_SPU_SET_STREAM	0x21
#define CTRL_SPU_SET_CLUT	0x22

/**
 * Audio attributes
 **/

typedef struct {
	int mode;		// 0=ac3, 1=mpeg, 2=lpcm
	int bits;		// 0=16bit, 1=20bitm 2=24bit
	int freq;		// 0=44.1kHz 1=48kHz 2=96kHz 3=22.05kHz 4=32kHz
	int stream;		// 0-7
	int volume;		// 0-100
} plugin_codec_attr_audio_t;

/**
 * Video attributes
 **/

typedef struct {
	int mode;		// 0=VOB, 1=VCD, 2=MPG
	int fps;		// 0=50Hz, 1=60Hz       
	int aspect_mode;	// 0=NORMAL, 1=PANSCAN, 2=LETTERBOX
	int aspect_output;	// 0=4:3, 3=16:9
	int tv_system;		// 0=NTSC, 1=NTSC60, 2=PAL, 3=PALM, 4=PALM60, 5=PALN, 6=PALNc, 7=PAL60
} plugin_codec_attr_video_t;

#endif
