/*****
*
* This file is part of the OMS program.
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by 
* the Free Software Foundation; either version 2, or (at your option)
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; see the file COPYING.  If not, write to
* the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*
*****/

#ifndef __OMS_PLUGIN_H__
#define __OMS_PLUGIN_H__

#include <inttypes.h>

/***** list of registered plugins *****/

typedef struct plugin_entry_struct {
	char *whoami;
	char *xml_config;
	uint32_t plugin_id;
	uint32_t *fourcc_in;
	uint32_t *fourcc_out;
	void *ops;

	struct plugin_entry_struct *next;	// next plugin with same plugin_id

// decapsulator only
	uint32_t magic_len;

// internal stuff
	struct plugin_entry_struct *depend;	// next plugin registered in the same *.so
} plugin_entry_t;

#ifdef USE_LIBLTDL
#include <ltdl.h>
#else
#define lt_dlhandle     void *
#define lt_dlinit()
#define lt_dlexit()     0;
#define lt_dlopen(a)    dlopen(a, RTLD_LAZY)
#define lt_dlopenext(a) dlopen(a, RTLD_LAZY)
#define lt_dlclose(a)   dlclose(a)
#define lt_dlsym(a,b)   dlsym(a,b)
#define lt_dlerror()    dlerror()
#endif

/***** prototypes ******/

int plugin_mgr_init (void);
int plugin_mgr_exit (void);
int plugin_mgr_scandir (const char *dir);

void *pluginLoad (uint32_t plugin_id, const char *fourcc_in, const char *fourcc_out);

lt_dlhandle plugin_load_file (char *path);
int plugin_unload (uint32_t plugin_id);
int plugin_init_nav (char *path);

void *plugin_get_active_ops (uint32_t plg_id);
plugin_entry_t *plugin_get_active (uint32_t plg_id);
int plugin_set_active (uint32_t plg_id, plugin_entry_t * plg_ops);

char *plugin_get_fourcc_in (uint32_t plg_id);
int plugin_set_fourcc_in (uint32_t plg_id, const char *fourcc);
char *plugin_get_fourcc_out (uint32_t plg_id);
int plugin_set_fourcc_out (uint32_t plg_id, const char *fourcc);

plugin_entry_t *plugin_get_registered (uint32_t plg_id);

plugin_entry_t *plugin_find (uint32_t plugin_id, uint32_t * fourcc_in, uint32_t * fourcc_out);

#endif
