
/*
 *
 * Copyright (C) 2000  Thomas Mirlacher
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * The author may be reached as <dent@linuxvideo.org>
 *
 *------------------------------------------------------------
 *
 */

#ifndef __OMS_H__
#define __OMS_H__

// oms/plugin/* uses this so need it above the includes
typedef void (*oms_callback_t) (void *, int);

#include <inttypes.h>
#include <oms/log.h>
#include <oms/plugin.h>		// for plugin_entry_t
#include <oms/plugin/nav.h>	// for nav_tree_t
#include <oms/config-engine.h>
#include <oms/oms_config.h>
#include <oms/buf.h>

/**
 * initialize oms
 **/

int oms_init (void);
int oms_exit (void);

/**
 * open input device/file and associated plugins
 **/

int omsOpenInput (char *);

/**
 * close current input device/file and associated plugins
 **/

int omsCloseInput (void);

/**
 * open audio output device
 **/

int omsOpenOutputAudio (const char *fourcc_in, const char *fourcc_out, const char *output_path);

/**
 * close audio output device
 **/

int omsCloseOutputAudio (void);

/**
 * open video output device
 **/

int omsOpenOutputVideo (const char *fourcc_in, const char *fourcc_out, const char *output_path);

/**
 * close video output device
 **/

int omsCloseOutputVideo (void);

/**
 * close current output device
 **/

int omsCloseOutput (void);

#define STATUS_STOP		0
#define STATUS_PAUSE		1
#define STATUS_PAUSE_ON		1
#define STATUS_PAUSE_OFF	2
#define STATUS_PLAY		3
#define STATUS_FINISH		4
#define STATUS_EJECT_T          5
#define STATUS_EJECT_F          6

/**
 * set status of navigator (see STATUS_* above)
 **/

int oms_set_status (int status);

/**
 * get internal information of navigator status 
 **/

int oms_get_status (void);

#define OMS_INFO_PROGRAM	0
#define OMS_INFO_AUDIO		1
#define OMS_INFO_SUBPIC		2

/**
 * get navigation tree (for DVD == PTT and for DVB == SI)
 **/

nav_tree_t *omsGetInfo (uint32_t info_id);

#define CB_BUF_DONE		1
#define CB_DEMUX_DONE		2
#define CB_PRINT		3

/**
 * register callbacks
 **/

int omsRegisterCb (uint32_t id, oms_callback_t cb, void *data);

/**
 * unregister callback
 **/

int omsUnregisterCb (uint32_t id);

int omsSetFilter (uint32_t id, int val);
int omsGetFilter (uint32_t id);

/*   Title:  1..99 */
/*   Part:   1..999 */
/*   PartsToPlay:   1..999 */
int omsPartPlayAutoStop (int title, int part, int parts2play);
int omsPartPlay (int title, int part);
int omsTitlePlay (int title);
int omsPlay (void);

void oms_demux (buf_t * buf, buf_entry_t * entry);

int oms_cmd (char *cmd, ...);

#endif				//__OMS_H__
