
/*
 *
 * Copyright (C) 1999-2000  Thomas Mirlacher
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * The author may be reached as <dent@linuxvideo.org>
 *
 *------------------------------------------------------------
 *
 */

#ifndef __FOURCC_H__
#define __FOURCC_H__

uint32_t string2FOURCC (const char *string);

#if BYTE_ORDER == BIG_ENDIAN
#define mmioFOURCC(a, b, c, d) ((a)<<24|(b)<<16|(c)<<8|(d))
#define mmioTWOCC(a, b) ((a)<<8|(b))
#else
#define mmioFOURCC(a, b, c, d) ((d)<<24|(c)<<16|(b)<<8|(a))
#define mmioTWOCC(a, b) ((b)<<8|(a))
#endif

#define FOURCC_PS	mmioFOURCC('p','s',' ',' ')

#define FOURCC_SPU	mmioFOURCC('s','p','u',' ')

#define FOURCC_AC3	mmioFOURCC('a','c','3',' ')
#define FOURCC_PCM	mmioFOURCC('p','c','m',' ')
#define FOURCC_MPEG	mmioFOURCC('m','p','e','g')
#define FOURCC_MPEG1	mmioFOURCC('m','p','g','1')
#define FOURCC_MP3	FOURCC_MPEG1
#define FOURCC_MPEG2	mmioFOURCC('m','p','g','2')

#define FOURCC_NAV	mmioFOURCC('n','a','v',' ')
#define FOURCC_DVD	mmioFOURCC('d','v','d',' ')
#define FOURCC_FILE	mmioFOURCC('f','i','l','e')
#define FOURCC_VCD	mmioFOURCC('v','c','d',' ')

#define FOURCC_SYS	mmioFOURCC('v','c','d',' ')
#define FOURCC_ESD	mmioFOURCC('e','s','d',' ')
#define FOURCC_VCD	mmioFOURCC('v','c','d',' ')

#endif
