
/*
 *
 * Copyright (C) 1999-2000  Thomas Mirlacher
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * The author may be reached as <dent@linuxvideo.org>
 *
 *------------------------------------------------------------
 *
 */

#ifndef __BUF_H__
#define __BUF_H__

#include <unistd.h>
#include <inttypes.h>
#include <pthread.h>
#include <oms/list.h>

#define BUF_ANY			0x0F
#define BUF_AUDIO		0x01
#define BUF_VIDEO		0x02
#define BUF_SUBPIC		0x04
#define BUF_OTHER		0x08
#define _BUF_MAX		5

#define BUF_FLAG_NONE		0x00
#define BUF_FLAG_SCR_VALID	0x01
#define BUF_FLAG_PTS_VALID	0x02
#define BUF_FLAG_NOMORE_DATA	0x04
#define BUF_FLAG_PUSI		0x08
#define BUF_FLAG_DISCONT	0x10
#define BUF_FLAG_INVALID	0x80

typedef enum {
	FREE, ALLOCATED, VALID, USED
} buf_entry_state;

typedef struct {
	struct list_head list;	// this HAS to be on top of this struct!!!

	buf_entry_state state;

	uint8_t *mem;		// pointer to memory in buffer  (e.g. PS stream)
	size_t mem_len;		// length of memory in buffer

	uint8_t *data;		// pointer to data in buffer    (e.g. ES stream)
	size_t data_len;	// length of data in buffer

	uint8_t buf_id;		// data identifier
	uint32_t type;		// data type

	uint8_t flags;

	uint64_t scr;		// system clock reference
	uint64_t pts;		// presentation time stamp
} buf_entry_t;

typedef struct {
	uint32_t entries_valid;

	struct list_head freelist;
	struct list_head validlist;

	pthread_mutex_t freemutex;
	pthread_mutex_t validmutex;

	uint8_t flags;
} buf_t;

buf_t *oms_buf_init (void);
void oms_buf_exit (buf_t * buf);

void oms_buf_flush (buf_t *buf, uint16_t buf_id);
int oms_buf_needs_refill (buf_t * buf);
int oms_buf_isempty (buf_t * buf);
int oms_buf_isfull (buf_t * buf);

/**
 * alloc demux buffer
 **/

buf_entry_t *oms_buf_alloc (buf_t * buf, size_t size);

/**
 * validate buffer (tell the demuxer it can access the data)
 **/

int oms_buf_validate (buf_t * buf, buf_entry_t * entry);

/**
 * invalidate buffer
 **/

void oms_buf_invalidate (buf_t * buf, buf_entry_t * entry);

/**
 * get buffer
 **/

buf_entry_t *oms_buf_get (buf_t * buf, uint32_t buf_id);

/**
 * free the buffer again
 **/

int oms_buf_free (buf_t * buf, buf_entry_t * buf_entry);


#endif
