
/*
 * DESCRIPTORS
 *
 * Copyright (C) 1998, 1999  Thomas Mirlacher
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * The author may be reached as <dent@linuxvideo.org>
 *
 *------------------------------------------------------------
 *
 */


#ifndef __DESCR_H__
#define __DESCR_H__

#include <inttypes.h>

#define DESCR_GEN_LEN 2

struct descr_gen_struct {
	uint8_t descriptor_tag		: 8;
	uint8_t descriptor_length	: 8;
};
typedef struct descr_gen_struct descr_gen_t;

#define get_descr(x) (((descr_gen_t *) x)->descriptor_tag)
#define get_descr_len(x) (((descr_gen_t *) x)->descriptor_length)

#define DESCR_NW_NAME		0x40
#define DESCR_SERVICE_LIST	0x41
#define DESCR_STUFFING		0x42
#define DESCR_SAT_DEL_SYS	0x43
#define DESCR_CABLE_DEL_SYS	0x44
#define DESCR_BOUQUET_NAME	0x47
#define DESCR_SERVICE		0x48
#define DESCR_COUNTRY_AVAIL	0x49
#define DESCR_LINKAGE		0x4A
#define DESCR_NVOD_REF		0x4B
#define DESCR_TIME_SHIFTED_SERVICE	0x4C
#define DESCR_MOSAIC		0x51
#define DESCR_STREAM_ID		0x52
#define DESCR_CA_IDENT		0x53
#define DESCR_TELETEXT		0x56
#define DESCR_TELEPHONE		0x57
#define DESCR_SUBTITLING	0x59
#define DESCR_TERR_DEL_SYS	0x5A
#define DESCR_ML_NW_NAME	0x5B
#define DESCR_ML_SERVICE_NAME	0x5D
#define DESCR_PRIV_DATA_SPEC	0x5F
#define DESCR_SERVICE_MOVE	0x5F

/* 0x43 satellite delivery system descriptor */

struct descr_satellite_delivery_system_struct {
	uint8_t frequency1		: 8;
	uint8_t frequency2		: 8;
	uint8_t frequency3		: 8;
	uint8_t frequency4		: 8;
	uint8_t orbital_position1	: 8;
	uint8_t orbital_position2	: 8;

#if BYTE_ORDER == BIG_ENDIAN
	uint8_t modulation		: 5;
	uint8_t polarization		: 2;
	uint8_t west_east_flag		: 1;
#else
	uint8_t west_east_flag		: 1;
	uint8_t polarization		: 2;
	uint8_t modulation		: 5;
#endif

	uint8_t symbol_rate1		: 8;
	uint8_t symbol_rate2		: 8;
	uint8_t symbol_rate3		: 8;

#if BYTE_ORDER == BIG_ENDIAN
	uint8_t symbol_rate4		: 4;
	uint8_t fec_inner		: 4;
#else
	uint8_t fec_inner		: 4;
	uint8_t symbol_rate4		: 4;
#endif
};

#endif
