/*
 *  Copyright (C) 1999-2000 Thomas Mirlacher, Guenter Bartsch
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Authors:	Thomas 'Dent' Mirlacher <dent@linuxvideo.org>
 *
 */


#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <gtk/gtk.h>

#include <oms/log.h>
#include <oms/plugin.h>

#include "config_gui.h"
#include "config_store.h"
#include "main.h"
#include "ui_xml.h"
 
extern config_t *cfg;
static GtkWidget *button;

static GtkWidget *parent_list[20];	// DENT: make this a linked list
					// for nesting boxes
const char *plugin;			// jcm: menu creation var
static int menu_index;		// jcm: menu creation var
static int parent_index;	

static void *_create_tab (GtkWidget *parent, const char *name) 
{
        GtkWidget *vbox = gtk_vbox_new (FALSE, 2);

        gtk_notebook_append_page (GTK_NOTEBOOK (parent), vbox, gtk_label_new (name));
        gtk_widget_show (vbox);
        
        return vbox;
}


static void *_create_frame (GtkWidget *parent, const char *name) 
{
        GtkWidget *frame;
	GtkWidget *vbox;

 	frame = gtk_frame_new (name);
	gtk_container_add (GTK_CONTAINER (parent), frame);

	vbox = gtk_vbox_new (FALSE, 2);
	gtk_container_add (GTK_CONTAINER (frame), vbox);

	gtk_widget_show (frame);
        gtk_widget_show (vbox);

        return vbox;
}


static void button_clicked (GtkWidget *widget, gpointer data) 
{
        const char *var = gtk_object_get_user_data (GTK_OBJECT (widget));
        char *value = (char *) data;

        config_set (cfg, NULL, var, value);
}


static void _create_radio_menu (const GtkWidget *parent, const char *name, const char *variable, int active) 
{
	GSList *group = NULL;
	static GtkWidget *menu;
	static GtkWidget *opt;
	int is_active;

	g_return_if_fail(name != NULL);

	if (!button) {
		opt = gtk_option_menu_new ();
		menu = gtk_menu_new ();
		gtk_option_menu_set_menu (GTK_OPTION_MENU (opt), menu);
		gtk_box_pack_start (GTK_BOX (parent), opt, FALSE, FALSE, 10);
		gtk_widget_show (opt);
		/* jcm: if you put the plugin assignment elsewhere it picks up
		 * each plugin as it's processed (not what we want.)
		 */
		plugin = config_get( cfg, NULL, variable);
                if ( plugin )
                        plugin = strdup(plugin);
                
                menu_index = 0;
	} else {
		group = gtk_radio_menu_item_group (GTK_RADIO_MENU_ITEM (button));
		menu_index++;
	}

	button = gtk_radio_menu_item_new_with_label (group, name);

	gtk_menu_append (GTK_MENU (menu), button); 
	gtk_object_set_user_data (GTK_OBJECT (button), (gpointer) variable);
	gtk_signal_connect (GTK_OBJECT (button), "activate", GTK_SIGNAL_FUNC(button_clicked), (gpointer) name);

	is_active = 0;

	if( plugin )
	{
	      	if( strncmp(plugin, name, strlen(plugin) ) == 0 )
		{
				is_active = 1;	
				gtk_option_menu_set_history ( (GtkOptionMenu *) opt, menu_index);
		}
	}

	gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (button), is_active);
 
        gtk_widget_show (button);
}

static void _create_radio (const GtkWidget *parent, const char *name, const char *variable, int active) 
{
	GSList *group = NULL;

	if (button)
		group = gtk_radio_button_group (GTK_RADIO_BUTTON (button));
	button = gtk_radio_button_new_with_label (group, name);
        
	//gtk_box_pack_start (GTK_BOX (parent), button, TRUE, TRUE, 0);
	gtk_container_add (GTK_CONTAINER (parent), button);
	gtk_object_set_user_data (GTK_OBJECT (button), (gpointer) variable);
	gtk_signal_connect (GTK_OBJECT (button), "pressed", GTK_SIGNAL_FUNC (button_clicked), (gpointer) name);

	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(button), active);
 
        gtk_widget_show (button);
}


static void _create_checkbox (const GtkWidget *parent, const char *name, const char *variable, int active) 
{
	GtkWidget *button;

	button = gtk_check_button_new_with_label (name);
        
	gtk_container_add (GTK_CONTAINER (parent), button);
	gtk_object_set_user_data (GTK_OBJECT (button), (gpointer) variable);
	gtk_signal_connect (GTK_OBJECT (button), "pressed", GTK_SIGNAL_FUNC (button_clicked), (gpointer) name);

	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (button), active);
        gtk_widget_show (button);
}


static void colorpicker_clicked (GtkWidget *w, GtkColorSelection *colorsel) 
{
        double color[3];
        char buf[1024];
        const char *variable = gtk_object_get_user_data(GTK_OBJECT(w));
                
        gtk_color_selection_get_color(colorsel, color);

        /*
         * color[0] = red, color[1] = green, color[2] = blue.
         */
        snprintf (buf, sizeof(buf), "%f,%f,%f", color[0], color[1], color[2]);
        config_set (cfg, NULL, variable, buf);
}


static void _create_colorpicker(const GtkWidget *parent, const char *variable, const char *name) 
{
        GtkWidget *frame, *cp;
      
        LOG (LOG_DEBUG, "create colorpicker parent = %p", parent);
        
        frame = gtk_frame_new (name);
        gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_OUT);
        gtk_container_add(GTK_CONTAINER(parent), frame);
        gtk_widget_show(frame);
        
        cp = gtk_color_selection_new();        
        gtk_container_add(GTK_CONTAINER(frame), cp);
        gtk_object_set_user_data(GTK_OBJECT(cp), (gpointer) variable);
        gtk_signal_connect(GTK_OBJECT(cp), "color_changed", GTK_SIGNAL_FUNC(colorpicker_clicked), cp);
        gtk_widget_show(cp);
}


void ui_xml_push_parent (void *parent)
{
	if (parent_list[parent_index])
		parent_index++;
	parent_list[parent_index] = (GtkWidget *) parent;
}


void *ui_xml_pop_parent (void)
{
	GtkWidget *parent = parent_list[parent_index];

	parent_list[parent_index] = NULL;
	if (parent_index > 0)
		parent_index--;

	return parent;
}

/* This is defined in ui_xml.h*/

void *ui_xml_render (const char *ctrl_name, const char *name, const char *var)
{
	GtkWidget *parent = parent_list[parent_index];

	if (!strcmp (ctrl_name, "tab")) {
		ui_xml_push_parent (_create_tab (parent, name));
	} else if (!strcmp (ctrl_name, "/tab")) {
		ui_xml_pop_parent ();
	} else if (!strcmp (ctrl_name, "frame")) {
		ui_xml_push_parent (_create_frame (parent, name));
	} else if (!strcmp (ctrl_name, "/frame")) {
		ui_xml_pop_parent ();
	} else if (!strcmp (ctrl_name, "radiogroup")) {
		button = NULL;
	} else if (!strcmp (ctrl_name, "/radiogroup")) {
		button = NULL;
	} else if (!strcmp (ctrl_name, "radiomenu")) {
		_create_radio_menu (parent, name, var, 1);
	} else if (!strcmp (ctrl_name, "radio")) {
		_create_radio (parent, name, var, 1);
	} else if (!strcmp (ctrl_name, "checkbox")) {
		_create_checkbox (parent, name, var, 1);
	} else if (!strcmp (ctrl_name, "colorpicker")) {
		_create_colorpicker (parent, name, var);
	} else {
		LOG (LOG_ERROR, "Un-handled tag %s", ctrl_name);
                return NULL;
	}

	return NULL;
}

