/*
 *  Copyright (C) 2000 Yoann Vandoorselaere.
 *
 *  This program is free software; you can redistribute it and/or modify 
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Authors:	Yoann Vandoorselaere <yoann@mandrakesoft.com>
 *		Thomas 'Dent' Mirlacher <dent@linuxvideo.org>
 *
 */


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <unistd.h>
#include <gnome-xml/parser.h>

#include <oms/log.h>
#include <oms/config-engine.h>
#include <oms/oms_config.h>
#include "ui_xml.h"

static omsConfigCb_t *config_cb = NULL;

/*
 * Handle the current tag by calling the wanted callback.
 */

static int _handle_xml_tag (xmlDocPtr doc, xmlNodePtr cur)
{
        const char *name, *variable;
        
        if (!cur || !cur->name)
                return -1;

        name = xmlGetProp (cur, "name");
        if (!name)
                name = "";

        variable = xmlGetProp (cur, "variable");
        if (!variable)
                variable = "";

	config_cb ((char *) cur->name, name, variable);

        return 0;
}


static void _walk_xml_tree (xmlDocPtr doc, xmlNodePtr cur)
{
        int ret;
       
        for (; cur; cur = cur->next ) {
                ret = _handle_xml_tag(doc, cur);
                if ( ret < 0 ) {
                        LOG (LOG_ERROR, "Tag %s doesn't have an handler", cur->name);
                        continue;
                }
        }
}


static void _create_plugin_page (const char *pname) 
{
        char buf[100];
        
        snprintf (buf, sizeof(buf), "%s options", pname);
}



static int _xml_parse (char *xml) 
{
        int ret;
        xmlDocPtr doc;
        xmlNodePtr cur;

        if ((ret = access (xml, R_OK)) < 0) {
                if (!(doc = xmlParseMemory (xml, strlen(xml)))) {
                        LOG (LOG_ERROR, "error calling xmlParseMemory : %s", strerror(errno));
                        return -1;
                }
        } else {
                if (!(doc = xmlParseFile (xml))) {
                        LOG (LOG_ERROR, "error calling xmlParseFile : %s", strerror(errno));
                        return -1;
                }
        }
        
        if (!(cur = doc->root)) {
                LOG (LOG_ERROR, "xml string seems to be empty");
                return -1;
        }
        
        _walk_xml_tree (doc, cur);
        
        xmlFreeDoc (doc);

        return 0;
}


int xmlParse (const char *pname, char *xml_string) 
{
        if (!config_cb)
                return -1;
        
        if (pname)
                _create_plugin_page (pname);

        if (xml_string)
                return _xml_parse (xml_string);

        return 0;
}


void uiRegisterConfigCb (omsConfigCb_t *p) 
{
        config_cb = p;
}
